/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.services.SearchService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record SearchServiceIndex(SearchService searchService) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.searchService;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.searchService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.searchService.getFullyQualifiedName()).weight(5).build());
        doc.put("suggest", suggest);
        doc.put("entityType", "searchService");
        doc.put("fqnParts", this.getFQNParts(this.searchService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("owner", this.getEntityWithDisplayName(this.searchService.getOwner()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.searchService.getFollowers()));
        return doc;
    }
}

