/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record StorageServiceIndex(StorageService storageService) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.storageService;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.storageService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.storageService.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.storageService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "storageService");
        doc.put("owner", this.getEntityWithDisplayName(this.storageService.getOwner()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.storageService.getFollowers()));
        return doc;
    }
}

