/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.StoredProcedure;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record StoredProcedureIndex(StoredProcedure storedProcedure) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.storedProcedure;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.storedProcedure.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.storedProcedure.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.storedProcedure.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "storedProcedure");
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("storedProcedure", (EntityInterface)this.storedProcedure));
        doc.put("tags", parseTags.getTags());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.storedProcedure.getFollowers()));
        doc.put("lineage", SearchIndex.getLineageData(this.storedProcedure.getEntityReference()));
        doc.put("tier", parseTags.getTierTag());
        doc.put("owner", this.getEntityWithDisplayName(this.storedProcedure.getOwner()));
        doc.put("service", this.getEntityWithDisplayName(this.storedProcedure.getService()));
        doc.put("totalVotes", CommonUtil.nullOrEmpty((Object)this.storedProcedure.getVotes()) ? 0 : this.storedProcedure.getVotes().getUpVotes() - this.storedProcedure.getVotes().getDownVotes());
        doc.put("domain", this.getEntityWithDisplayName(this.storedProcedure.getDomain()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        return SearchIndex.getDefaultFields();
    }
}

