/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record TagIndex(Tag tag) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.tag;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.tag.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.tag.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.tag.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        if (this.tag.getDisabled() != null && this.tag.getDisabled().booleanValue()) {
            doc.put("disabled", this.tag.getDisabled());
        } else {
            doc.put("disabled", "false");
        }
        doc.put("suggest", suggest);
        doc.put("entityType", "tag");
        doc.put("followers", SearchIndexUtils.parseFollowers(this.tag.getFollowers()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("classification.name", Float.valueOf(7.0f));
        return fields;
    }
}

