/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class TeamIndex
implements SearchIndex {
    final Team team;
    final Set<String> excludeFields = Set.of("owns");

    public TeamIndex(Team team) {
        this.team = team;
    }

    @Override
    public Object getEntity() {
        return this.team;
    }

    @Override
    public Set<String> getExcludedFields() {
        return this.excludeFields;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.team.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.team.getDisplayName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.team.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "team");
        doc.put("isBot", false);
        doc.put("displayName", CommonUtil.nullOrEmpty((String)this.team.getDisplayName()) ? this.team.getName() : this.team.getDisplayName());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.team.getFollowers()));
        return doc;
    }
}

