/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record TestCaseIndex(TestCase testCase) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.testCase;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> esDoc) {
        ArrayList<TestSuite> testSuiteArray = new ArrayList<TestSuite>();
        if (this.testCase.getTestSuites() != null) {
            for (TestSuite suite : this.testCase.getTestSuites()) {
                suite.setChangeDescription(null);
                testSuiteArray.add(suite);
            }
        }
        this.testCase.setTestSuites(testSuiteArray);
        Map<String, Object> doc = JsonUtils.getMap(this.testCase);
        SearchIndexUtils.removeNonIndexableFields(doc, DEFAULT_EXCLUDED_FIELDS);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.testCase.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.testCase.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.testCase.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "testCase");
        doc.put("owner", this.getEntityWithDisplayName(this.testCase.getOwner()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.testCase.getFollowers()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("testSuite.fullyQualifiedName", Float.valueOf(10.0f));
        fields.put("testSuite.name", Float.valueOf(10.0f));
        fields.put("testSuite.description", Float.valueOf(1.0f));
        fields.put("entityLink", Float.valueOf(3.0f));
        fields.put("entityFQN", Float.valueOf(10.0f));
        return fields;
    }
}

