/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record TestSuiteIndex(TestSuite testSuite) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.testSuite;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.testSuite.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.testSuite.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.testSuite.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "testSuite");
        doc.put("owner", this.getEntityWithDisplayName(this.testSuite.getOwner()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.testSuite.getFollowers()));
        return doc;
    }
}

