/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.type.Field;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.FlattenSchemaField;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.FullyQualifiedName;

public class TopicIndex
implements SearchIndex {
    final Set<String> excludeTopicFields = Set.of("sampleData", "messageSchema");
    final Topic topic;

    public TopicIndex(Topic topic) {
        this.topic = topic;
    }

    @Override
    public Object getEntity() {
        return this.topic;
    }

    @Override
    public Set<String> getExcludedFields() {
        return this.excludeTopicFields;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> fieldSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        HashSet<List<TagLabel>> tagsWithChildren = new HashSet<List<TagLabel>>();
        ArrayList<String> fieldsWithChildrenName = new ArrayList<String>();
        suggest.add(SearchSuggest.builder().input(this.topic.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.topic.getName()).weight(10).build());
        serviceSuggest.add(SearchSuggest.builder().input(this.topic.getService().getName()).weight(5).build());
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeTopicFields);
        if (this.topic.getMessageSchema() != null && this.topic.getMessageSchema().getSchemaFields() != null && !this.topic.getMessageSchema().getSchemaFields().isEmpty()) {
            ArrayList<FlattenSchemaField> flattenFields = new ArrayList<FlattenSchemaField>();
            this.parseSchemaFields(this.topic.getMessageSchema().getSchemaFields(), flattenFields, null);
            for (FlattenSchemaField field : flattenFields) {
                fieldSuggest.add(SearchSuggest.builder().input(field.getName()).weight(5).build());
                fieldsWithChildrenName.add(field.getName());
                if (field.getTags() == null) continue;
                tagsWithChildren.add(field.getTags());
            }
            doc.put("fieldNames", fieldsWithChildrenName);
        }
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("topic", (EntityInterface)this.topic));
        tagsWithChildren.add(parseTags.getTags());
        List flattenedTagList = tagsWithChildren.stream().flatMap(Collection::stream).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        doc.put("displayName", this.topic.getDisplayName() != null ? this.topic.getDisplayName() : this.topic.getName());
        doc.put("tags", flattenedTagList);
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.topic.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("field_suggest", fieldSuggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("entityType", "topic");
        doc.put("serviceType", this.topic.getServiceType());
        doc.put("lineage", SearchIndex.getLineageData(this.topic.getEntityReference()));
        doc.put("totalVotes", CommonUtil.nullOrEmpty((Object)this.topic.getVotes()) ? 0 : this.topic.getVotes().getUpVotes() - this.topic.getVotes().getDownVotes());
        doc.put("messageSchema", this.topic.getMessageSchema() != null ? this.topic.getMessageSchema() : null);
        doc.put("fqnParts", this.getFQNParts(this.topic.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("owner", this.getEntityWithDisplayName(this.topic.getOwner()));
        doc.put("service", this.getEntityWithDisplayName(this.topic.getService()));
        doc.put("domain", this.getEntityWithDisplayName(this.topic.getDomain()));
        return doc;
    }

    private void parseSchemaFields(List<Field> fields, List<FlattenSchemaField> flattenSchemaFields, String parentSchemaField) {
        Optional<String> optParentField = Optional.ofNullable(parentSchemaField).filter(Predicate.not(String::isEmpty));
        List<TagLabel> tags = new ArrayList();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (optParentField.isPresent()) {
                fieldName = FullyQualifiedName.add(optParentField.get(), fieldName);
            }
            if (field.getTags() != null) {
                tags = field.getTags();
            }
            FlattenSchemaField flattenSchemaField = FlattenSchemaField.builder().name(fieldName).description(field.getDescription()).build();
            if (!tags.isEmpty()) {
                flattenSchemaField.setTags(tags);
            }
            flattenSchemaFields.add(flattenSchemaField);
            if (field.getChildren() == null) continue;
            this.parseSchemaFields(field.getChildren(), flattenSchemaFields, field.getName());
        }
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("messageSchema.schemaFields.name", Float.valueOf(7.0f));
        fields.put("messageSchema.schemaFields.name.keyword", Float.valueOf(5.0f));
        fields.put("messageSchema.schemaFields.description", Float.valueOf(1.0f));
        fields.put("messageSchema.schemaFields.children.name", Float.valueOf(7.0f));
        fields.put("messageSchema.schemaFields.children.keyword", Float.valueOf(5.0f));
        return fields;
    }
}

