/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class UserIndex
implements SearchIndex {
    final User user;
    final Set<String> excludeFields = Set.of("owns", "follows", "authenticationMechanism");

    public UserIndex(User user) {
        this.user = user;
    }

    @Override
    public Object getEntity() {
        return this.user;
    }

    @Override
    public Set<String> getExcludedFields() {
        return this.excludeFields;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.user.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.user.getDisplayName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.user.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "user");
        doc.put("displayName", CommonUtil.nullOrEmpty((String)this.user.getDisplayName()) ? this.user.getName() : this.user.getDisplayName());
        if (this.user.getIsBot() == null) {
            doc.put("isBot", false);
        }
        doc.put("followers", SearchIndexUtils.parseFollowers(this.user.getFollowers()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        return SearchIndex.getDefaultFields();
    }
}

