/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import java.security.Principal;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CatalogSecurityContext(Principal principal, String scheme, String authenticationScheme) implements SecurityContext
{
    private static final Logger LOG = LoggerFactory.getLogger(CatalogSecurityContext.class);
    public static final String OPENID_AUTH = "openid";

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        LOG.debug("isUserInRole user: {}, role: {}", (Object)this.principal, (Object)role);
        return false;
    }

    public boolean isSecure() {
        return "https".equals(this.scheme);
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    @Override
    public String toString() {
        return String.format("catalogSecurityContext{principal=%s, scheme='%s', authenticationSchema='%s', isSecure=%s}", this.principal, this.scheme, this.authenticationScheme, this.isSecure());
    }
}

