/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;

public interface DataInsightAggregatorInterface {
    public static final String ENTITY_TYPE = "entityType";
    public static final String SERVICE_NAME = "serviceName";
    public static final String COMPLETED_DESCRIPTION_FRACTION = "completedDescriptionFraction";
    public static final String HAS_OWNER_FRACTION = "hasOwnerFraction";
    public static final String ENTITY_COUNT = "entityCount";
    public static final String TIMESTAMP = "timestamp";
    public static final String ENTITY_TIER = "entityTier";

    default public DataInsightChartResult process(DataInsightChartResult.DataInsightChartType chartType) throws ParseException {
        List<Object> data = this.aggregate();
        return new DataInsightChartResult().withData(data).withChartType(chartType);
    }

    public List<Object> aggregate() throws ParseException;

    default public Long convertDatTimeStringToTimestamp(String dateTimeString) throws ParseException {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        return dateTimeFormat.parse(dateTimeString).getTime();
    }
}

