/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.entity;

import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.util.JsonUtils;

public class QueryFormatter
implements EntityFormatter {
    private static final String QUERY_USED_IN_FIELD = "queryUsedIn";

    @Override
    public String format(MessageDecorator<?> messageFormatter, Thread thread, FieldChange fieldChange, FormatterUtil.CHANGE_TYPE changeType) {
        if (QUERY_USED_IN_FIELD.equals(fieldChange.getName())) {
            return this.transformQueryUsedIn(messageFormatter, thread, fieldChange, changeType);
        }
        return FormatterUtil.transformMessage(messageFormatter, thread, fieldChange, changeType);
    }

    private String transformQueryUsedIn(MessageDecorator<?> messageFormatter, Thread thread, FieldChange fieldChange, FormatterUtil.CHANGE_TYPE changeType) {
        String newVal = QueryFormatter.getFieldValue(fieldChange.getNewValue(), messageFormatter, thread);
        String oldVal = QueryFormatter.getFieldValue(fieldChange.getOldValue(), messageFormatter, thread);
        return FormatterUtil.transformMessage(messageFormatter, thread, new FieldChange().withNewValue((Object)newVal).withOldValue((Object)oldVal).withName(QUERY_USED_IN_FIELD), changeType);
    }

    private static String getFieldValue(Object fieldValue, MessageDecorator<?> messageFormatter, Thread thread) {
        List<EntityReference> tableRefs;
        Query query = (Query)Entity.getEntity(thread.getEntityType(), thread.getEntityId(), "id", Include.ALL);
        StringBuilder field = new StringBuilder();
        List<EntityReference> list = tableRefs = fieldValue instanceof String ? JsonUtils.readObjects(fieldValue.toString(), EntityReference.class) : (List<EntityReference>)fieldValue;
        if (!CommonUtil.nullOrEmpty(tableRefs)) {
            field.append("for '").append(query.getQuery()).append("', ").append(messageFormatter.getLineBreak());
            field.append("Query Used in :- ");
            int i = 1;
            for (EntityReference ref : tableRefs) {
                field.append(messageFormatter.getEntityUrl(ref.getType(), ref.getFullyQualifiedName(), ""));
                if (i < tableRefs.size()) {
                    field.append(", ");
                }
                ++i;
            }
        }
        return field.toString();
    }
}

