/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import io.jsonwebtoken.lang.Collections;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.tuple.Triple;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.json.JSONObject;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.CloseTask;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.api.feed.ThreadCount;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.Reaction;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.formatter.decorators.FeedMessageDecorator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.util.FeedMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedFilter;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.resources.feeds.FeedResource;
import org.openmetadata.service.resources.feeds.FeedUtil;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Repository
public class FeedRepository {
    private static final Logger LOG = LoggerFactory.getLogger(FeedRepository.class);
    public static final String DELETED_USER_NAME = "DeletedUser";
    public static final String DELETED_USER_DISPLAY = "User was deleted";
    public static final String DELETED_TEAM_NAME = "DeletedTeam";
    public static final String DELETED_TEAM_DISPLAY = "Team was deleted";
    private final CollectionDAO dao = Entity.getCollectionDAO();
    private static final MessageDecorator<FeedMessage> FEED_MESSAGE_FORMATTER = new FeedMessageDecorator();

    public FeedRepository() {
        Entity.setFeedRepository(this);
        ResourceRegistry.addResource("feed", null, Entity.getEntityFields(Thread.class));
    }

    public int getNextTaskId() {
        this.dao.feedDAO().updateTaskId();
        return this.dao.feedDAO().getTaskId();
    }

    private ThreadContext getThreadContext(Thread thread) {
        return new ThreadContext(thread);
    }

    private ThreadContext getThreadContext(Thread thread, ChangeEvent event) {
        return new ThreadContext(thread, event);
    }

    @Transaction
    public Thread create(Thread thread) {
        ThreadContext threadContext = this.getThreadContext(thread);
        return this.createThread(threadContext);
    }

    @Transaction
    public void create(Thread thread, ChangeEvent event) {
        ThreadContext threadContext = this.getThreadContext(thread, event);
        this.createThread(threadContext);
    }

    @Transaction
    public void store(ThreadContext threadContext) {
        this.dao.feedDAO().insert(JsonUtils.pojoToJson(threadContext.getThread()));
    }

    @Transaction
    public void storeRelationships(ThreadContext threadContext) {
        Thread thread = threadContext.getThread();
        MessageParser.EntityLink about = threadContext.getAbout();
        this.dao.relationshipDAO().insert(threadContext.getCreatedBy().getId(), thread.getId(), "user", "THREAD", Relationship.CREATED.ordinal());
        this.dao.fieldRelationshipDAO().insert(thread.getId().toString(), about.getFullyQualifiedFieldValue(), thread.getId().toString(), about.getFullyQualifiedFieldValue(), "THREAD", about.getFullyQualifiedFieldType(), Relationship.IS_ABOUT.ordinal(), null);
        EntityReference entityOwner = threadContext.getAboutEntity().getOwner();
        if (entityOwner != null) {
            this.dao.relationshipDAO().insert(thread.getId(), entityOwner.getId(), "THREAD", entityOwner.getType(), Relationship.ADDRESSED_TO.ordinal());
        }
        this.storeMentions(thread, thread.getMessage());
    }

    public Thread getTask(MessageParser.EntityLink about, TaskType taskType) {
        List<Triple<String, String, String>> tasks = this.dao.fieldRelationshipDAO().findFrom(about.getFullyQualifiedFieldValue(), about.getFullyQualifiedFieldType(), Relationship.IS_ABOUT.ordinal());
        for (Triple<String, String, String> task : tasks) {
            UUID threadId;
            Thread thread;
            if (!((String)task.getMiddle()).equals("THREAD") || (thread = EntityUtil.validate(threadId = UUID.fromString((String)task.getLeft()), this.dao.feedDAO().findById(threadId), Thread.class)).getTask() == null || thread.getTask().getType() != taskType) continue;
            return thread;
        }
        throw new EntityNotFoundException(String.format("Task for entity %s of type %s was not found", about.getEntityType(), taskType));
    }

    private Thread createThread(ThreadContext threadContext) {
        Thread thread = threadContext.getThread();
        if (thread.getType() == ThreadType.Task) {
            this.validateAssignee(thread);
            thread.getTask().withId(Integer.valueOf(this.getNextTaskId()));
        } else if (thread.getType() == ThreadType.Announcement) {
            this.validateAnnouncement(thread);
        }
        this.store(threadContext);
        this.storeRelationships(threadContext);
        this.populateAssignees(threadContext.getThread());
        return threadContext.getThread();
    }

    public Thread get(UUID id) {
        Thread thread = EntityUtil.validate(id, this.dao.feedDAO().findById(id), Thread.class);
        this.sortPosts(thread);
        return thread;
    }

    public Thread getTask(Integer id) {
        Thread task = EntityUtil.validate(id, this.dao.feedDAO().findByTaskId(id), Thread.class);
        this.sortPosts(task);
        return this.populateAssignees(task);
    }

    public RestUtil.PatchResponse<Thread> closeTask(UriInfo uriInfo, Thread thread, String user, CloseTask closeTask) {
        this.closeTask(thread, user, closeTask);
        Thread updatedHref = FeedResource.addHref(uriInfo, thread);
        return new RestUtil.PatchResponse<Thread>(Response.Status.OK, updatedHref, EventType.TASK_CLOSED);
    }

    public RestUtil.PatchResponse<Thread> resolveTask(UriInfo uriInfo, Thread thread, String user, ResolveTask resolveTask) {
        ThreadContext threadContext = this.getThreadContext(thread);
        this.resolveTask(threadContext, user, resolveTask);
        Thread updatedHref = FeedResource.addHref(uriInfo, thread);
        return new RestUtil.PatchResponse<Thread>(Response.Status.OK, updatedHref, EventType.TASK_RESOLVED);
    }

    protected void resolveTask(ThreadContext threadContext, String user, ResolveTask resolveTask) {
        TaskWorkflow taskWorkflow = threadContext.getTaskWorkflow();
        EntityInterface aboutEntity = threadContext.getAboutEntity();
        String origJson = JsonUtils.pojoToJson(aboutEntity);
        EntityInterface updatedEntity = taskWorkflow.performTask(user, resolveTask);
        String updatedEntityJson = JsonUtils.pojoToJson(updatedEntity);
        JsonPatch patch = JsonUtils.getJsonPatch(origJson, updatedEntityJson);
        EntityRepository<? extends EntityInterface> repository = threadContext.getEntityRepository();
        repository.patch(null, aboutEntity.getId(), user, patch);
        threadContext.getThread().getTask().withNewValue(resolveTask.getNewValue());
        this.closeTask(threadContext.getThread(), user, new CloseTask());
    }

    private static String getTagFQNs(List<TagLabel> tags) {
        return tags.stream().map(TagLabel::getTagFQN).collect(Collectors.joining(", "));
    }

    @Transaction
    private void addClosingPost(Thread thread, String user, String closingComment) {
        TaskDetails task;
        TaskType type;
        String message = closingComment != null ? FeedRepository.closeTaskMessage(closingComment) : (EntityUtil.isDescriptionTask(type = (task = thread.getTask()).getType()) ? FeedRepository.resolveDescriptionTaskMessage(task) : (EntityUtil.isTagTask(type) ? FeedRepository.resolveTagTaskMessage(task) : "Resolved the Task."));
        Post post = new Post().withId(UUID.randomUUID()).withMessage(message).withFrom(user).withReactions(java.util.Collections.emptyList()).withPostTs(Long.valueOf(System.currentTimeMillis()));
        this.addPostToThread(thread.getId(), post, user);
    }

    @Transaction
    public void closeTask(Thread thread, String user, CloseTask closeTask) {
        ThreadContext threadContext = this.getThreadContext(thread);
        TaskDetails task = thread.getTask();
        if (task.getStatus() != TaskStatus.Open) {
            return;
        }
        TaskWorkflow workflow = threadContext.getTaskWorkflow();
        workflow.closeTask(user, closeTask);
        task.withStatus(TaskStatus.Closed).withClosedBy(user).withClosedAt(Long.valueOf(System.currentTimeMillis()));
        thread.withTask(task).withUpdatedBy(user).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        this.dao.feedDAO().update(thread.getId(), JsonUtils.pojoToJson(thread));
        this.addClosingPost(thread, user, closeTask.getComment());
        this.sortPosts(thread);
    }

    @Transaction
    public void closeTaskWithoutWorkflow(Thread thread, String user, CloseTask closeTask) {
        TaskDetails task = thread.getTask();
        if (task.getStatus() != TaskStatus.Open) {
            return;
        }
        task.withStatus(TaskStatus.Closed).withClosedBy(user).withClosedAt(Long.valueOf(System.currentTimeMillis()));
        thread.withTask(task).withUpdatedBy(user).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        this.dao.feedDAO().update(thread.getId(), JsonUtils.pojoToJson(thread));
        this.addClosingPost(thread, user, closeTask.getComment());
        this.sortPosts(thread);
    }

    private void storeMentions(Thread thread, String message) {
        List<MessageParser.EntityLink> mentions = MessageParser.getEntityLinks(message);
        mentions.stream().distinct().forEach(mention -> this.dao.fieldRelationshipDAO().insert(mention.getFullyQualifiedFieldValue(), thread.getId().toString(), mention.getFullyQualifiedFieldValue(), thread.getId().toString(), mention.getFullyQualifiedFieldType(), "THREAD", Relationship.MENTIONED_IN.ordinal(), null));
    }

    @Transaction
    public Thread addPostToThread(UUID id, Post post, String userName) {
        UUID fromUserId = Entity.getEntityReferenceByName("user", post.getFrom(), Include.NON_DELETED).getId();
        Thread thread = EntityUtil.validate(id, this.dao.feedDAO().findById(id), Thread.class);
        this.populateAssignees(thread);
        thread.withUpdatedBy(userName).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        FeedUtil.addPost(thread, post);
        this.dao.feedDAO().update(id, JsonUtils.pojoToJson(thread));
        boolean relationAlreadyExists = thread.getPosts().stream().anyMatch(p -> p.getFrom().equals(post.getFrom()));
        if (!relationAlreadyExists) {
            this.dao.relationshipDAO().insert(fromUserId, thread.getId(), "user", "THREAD", Relationship.REPLIED_TO.ordinal());
        }
        this.storeMentions(thread, post.getMessage());
        this.sortPostsInThreads(List.of(thread));
        return thread;
    }

    public Post getPostById(Thread thread, UUID postId) {
        Optional<Post> post = thread.getPosts().stream().filter(p -> p.getId().equals(postId)).findAny();
        if (post.isEmpty()) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("Post", postId));
        }
        return post.get();
    }

    @Transaction
    public RestUtil.DeleteResponse<Post> deletePost(Thread thread, Post post, String userName) {
        List<Post> posts = thread.getPosts();
        posts = posts.stream().filter(p -> !p.getId().equals(post.getId())).toList();
        thread.withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withUpdatedBy(userName).withPosts(posts).withPostsCount(Integer.valueOf(posts.size()));
        this.dao.feedDAO().update(thread.getId(), JsonUtils.pojoToJson(thread));
        return new RestUtil.DeleteResponse<Post>(post, EventType.ENTITY_DELETED);
    }

    @Transaction
    public RestUtil.DeleteResponse<Thread> deleteThread(Thread thread, String deletedByUser) {
        this.deleteThreadInternal(thread.getId());
        LOG.debug("{} deleted thread with id {}", (Object)deletedByUser, (Object)thread.getId());
        return new RestUtil.DeleteResponse<Thread>(thread, EventType.ENTITY_DELETED);
    }

    @Transaction
    public void deleteThreadInternal(UUID id) {
        this.dao.relationshipDAO().deleteAll(id, "THREAD");
        this.dao.fieldRelationshipDAO().deleteAllByPrefix(id.toString());
        this.dao.feedDAO().delete(id);
    }

    @Transaction
    public void deleteByAbout(UUID entityId) {
        List threadIds = CommonUtil.listOrEmpty(this.dao.feedDAO().findByEntityId(entityId.toString()));
        for (String threadId : threadIds) {
            try {
                this.deleteThreadInternal(UUID.fromString(threadId));
            }
            catch (Exception exception) {}
        }
    }

    public List<ThreadCount> getThreadsCount(String link) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(link);
        ArrayList<ThreadCount> threadCounts = new ArrayList<ThreadCount>();
        EntityReference reference = EntityUtil.validateEntityLink(entityLink);
        if (reference.getType().equals("user") || reference.getType().equals("team")) {
            int mentions;
            List<Object> result;
            if (reference.getType().equals("user")) {
                UUID userId = reference.getId();
                User user = (User)Entity.getEntity("user", userId, "teams", Include.NON_DELETED);
                List<String> teamIds = this.getTeamIds(user);
                List<String> teamNames = this.getTeamNames(user);
                String userTeamJsonMysql = this.getUserTeamJsonMysql(userId, teamIds);
                List<String> userTeamJsonPostgres = this.getUserTeamJsonPostgres(userId, teamIds);
                result = this.dao.feedDAO().listCountByOwner(userId, teamIds, user.getName(), userTeamJsonMysql, userTeamJsonPostgres);
                mentions = this.dao.feedDAO().listCountThreadsByMentions(FullyQualifiedName.buildHash(user.getFullyQualifiedName()), teamNames, Relationship.MENTIONED_IN.ordinal(), " where true ");
            } else {
                mentions = 0;
                result = new ArrayList();
            }
            ThreadCount threadCount = new ThreadCount().withMentionCount(Integer.valueOf(mentions));
            threadCount.setEntityLink(link);
            result.forEach(l -> {
                String type = (String)l.get(0);
                String taskStatus = (String)l.get(1);
                int count = Integer.parseInt((String)l.get(2));
                if (type.equalsIgnoreCase("Conversation")) {
                    threadCount.setConversationCount(Integer.valueOf(count));
                } else if (type.equalsIgnoreCase("Task")) {
                    if (taskStatus.equals("Open")) {
                        threadCount.setOpenTaskCount(Integer.valueOf(count));
                    } else if (taskStatus.equals("Closed")) {
                        threadCount.setClosedTaskCount(Integer.valueOf(count));
                    }
                }
            });
            this.computeTotalTaskCount(threadCount);
            threadCounts.add(threadCount);
        } else {
            int mentions = 0;
            List<List<String>> result = this.dao.feedDAO().listCountByEntityLink(reference.getId(), reference.getFullyQualifiedName(), entityLink.getFullyQualifiedFieldType());
            result.forEach(l -> {
                ThreadCount threadCount = new ThreadCount().withMentionCount(Integer.valueOf(mentions));
                String eLink = (String)l.get(0);
                String type = (String)l.get(1);
                String taskStatus = (String)l.get(2);
                threadCount.setEntityLink(eLink);
                int count = Integer.parseInt((String)l.get(3));
                if (type.equalsIgnoreCase("Conversation")) {
                    threadCount.setConversationCount(Integer.valueOf(count));
                } else if (type.equalsIgnoreCase("Task")) {
                    if (taskStatus.equals("Open")) {
                        threadCount.setOpenTaskCount(Integer.valueOf(count));
                    } else if (taskStatus.equals("Closed")) {
                        threadCount.setClosedTaskCount(Integer.valueOf(count));
                    }
                }
                this.computeTotalTaskCount(threadCount);
                threadCounts.add(threadCount);
            });
        }
        return threadCounts;
    }

    private void computeTotalTaskCount(ThreadCount threadCount) {
        threadCount.setTotalTaskCount(Integer.valueOf((threadCount.getOpenTaskCount() != null ? threadCount.getOpenTaskCount() : 0) + (threadCount.getClosedTaskCount() != null ? threadCount.getClosedTaskCount() : 0)));
    }

    public List<Post> listPosts(UUID threadId) {
        return this.get(threadId).getPosts();
    }

    public ResultList<Thread> list(FeedFilter filter, String link, int limitPosts, UUID userId, int limit) {
        int total;
        List<Thread> threads;
        if (link == null && userId == null) {
            List<String> jsons = this.dao.feedDAO().list(limit + 1, filter.getCondition());
            threads = JsonUtils.readObjects(jsons, Thread.class);
            total = this.dao.feedDAO().listCount(filter.getCondition());
        } else if (link != null) {
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(link);
            EntityReference reference = EntityUtil.validateEntityLink(entityLink);
            if (reference.getType().equals("user")) {
                FilteredThreads filteredThreads = this.getThreadsByOwner(filter, reference.getId(), limit + 1);
                threads = filteredThreads.threads();
                total = filteredThreads.totalCount();
            } else {
                User user = userId != null ? (User)Entity.getEntity("user", userId, "teams", Include.NON_DELETED) : null;
                List<String> teamNameHash = this.getTeamNames(user);
                String userName = user == null ? null : user.getFullyQualifiedName();
                List<String> jsons = this.dao.feedDAO().listThreadsByEntityLink(filter, entityLink, limit + 1, Relationship.IS_ABOUT.ordinal(), userName, teamNameHash);
                threads = JsonUtils.readObjects(jsons, Thread.class);
                total = this.dao.feedDAO().listCountThreadsByEntityLink(filter, entityLink, Relationship.IS_ABOUT.ordinal(), userName, teamNameHash);
            }
        } else {
            FilteredThreads filteredThreads = ThreadType.Task.equals((Object)filter.getThreadType()) ? (FilterType.ASSIGNED_BY.equals((Object)filter.getFilterType()) ? this.getTasksAssignedBy(filter, userId, limit + 1) : (FilterType.ASSIGNED_TO.equals((Object)filter.getFilterType()) ? this.getTasksAssignedTo(filter, userId, limit + 1) : this.getTasksOfUser(filter, userId, limit + 1))) : (FilterType.FOLLOWS.equals((Object)filter.getFilterType()) ? this.getThreadsByFollows(filter, userId, limit + 1) : (FilterType.MENTIONS.equals((Object)filter.getFilterType()) ? this.getThreadsByMentions(filter, userId, limit + 1) : (FilterType.OWNER_OR_FOLLOWS.equals((Object)filter.getFilterType()) ? this.getThreadsByOwnerOrFollows(filter, userId, limit + 1) : this.getThreadsByOwner(filter, userId, limit + 1))));
            threads = filteredThreads.threads();
            total = filteredThreads.totalCount();
        }
        this.sortAndLimitPosts(threads, limitPosts);
        this.populateAssignees(threads);
        String beforeCursor = null;
        String afterCursor = null;
        if (filter.getPaginationType() == PaginationType.BEFORE) {
            if (threads.size() > limit) {
                threads.remove(0);
                beforeCursor = threads.get(0).getUpdatedAt().toString();
            }
            afterCursor = threads.get(threads.size() - 1).getUpdatedAt().toString();
        } else {
            String string = beforeCursor = filter.getAfter() == null ? null : threads.get(0).getUpdatedAt().toString();
            if (threads.size() > limit) {
                threads.remove(limit);
                afterCursor = threads.get(limit - 1).getUpdatedAt().toString();
            }
        }
        return new ResultList<Thread>(threads, beforeCursor, afterCursor, total);
    }

    @Transaction
    private void storeReactions(Thread thread, String user) {
        this.dao.fieldRelationshipDAO().insert(EntityInterfaceUtil.quoteName((String)user), thread.getId().toString(), user, thread.getId().toString(), "user", "THREAD", Relationship.REACTED_TO.ordinal(), null);
    }

    public final RestUtil.PatchResponse<Post> patchPost(Thread thread, Post post, String user, JsonPatch patch) {
        Post updated = JsonUtils.applyPatch(post, patch, Post.class);
        this.restorePatchAttributes(post, updated);
        this.populateUserReactions(updated.getReactions());
        List posts = thread.getPosts();
        posts = posts.stream().filter(p -> !p.getId().equals(post.getId())).collect(Collectors.toList());
        posts.add(updated);
        thread.withPosts(posts).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withUpdatedBy(user);
        if (!updated.getReactions().isEmpty()) {
            updated.getReactions().forEach(reaction -> this.storeReactions(thread, reaction.getUser().getName()));
        }
        this.sortPosts(thread);
        EventType change = this.patchUpdate(thread, post, updated) ? EventType.POST_UPDATED : EventType.ENTITY_NO_CHANGE;
        return new RestUtil.PatchResponse<Post>(Response.Status.OK, updated, change);
    }

    public final RestUtil.PatchResponse<Thread> patchThread(UriInfo uriInfo, UUID id, String user, JsonPatch patch) {
        Thread original = this.get(id);
        if (original.getTask() != null) {
            List assignees = original.getTask().getAssignees();
            this.populateAssignees(original);
            assignees.sort(EntityUtil.compareEntityReference);
        }
        Thread updated = JsonUtils.applyPatch(original, patch, Thread.class);
        updated.withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withUpdatedBy(user);
        this.restorePatchAttributes(original, updated);
        if (!CommonUtil.nullOrEmpty((List)updated.getReactions())) {
            this.populateUserReactions(updated.getReactions());
            updated.getReactions().forEach(reaction -> this.storeReactions(updated, reaction.getUser().getName()));
        }
        if (updated.getTask() != null) {
            this.populateAssignees(updated);
            updated.getTask().getAssignees().sort(EntityUtil.compareEntityReference);
            this.validateAssignee(updated);
        }
        if (updated.getAnnouncement() != null) {
            this.validateAnnouncement(updated);
        }
        EventType change = this.patchUpdate(original, updated) ? EventType.THREAD_UPDATED : EventType.ENTITY_NO_CHANGE;
        this.sortPosts(updated);
        Thread updatedHref = FeedResource.addHref(uriInfo, updated);
        return new RestUtil.PatchResponse<Thread>(Response.Status.OK, updatedHref, change);
    }

    public void checkPermissionsForResolveTask(Authorizer authorizer, Thread thread, boolean closeTask, SecurityContext securityContext) {
        String userName = securityContext.getUserPrincipal().getName();
        User user = (User)Entity.getEntityByName("user", userName, "teams", Include.NON_DELETED);
        MessageParser.EntityLink about = MessageParser.EntityLink.parse(thread.getAbout());
        EntityReference aboutRef = EntityUtil.validateEntityLink(about);
        ThreadContext threadContext = this.getThreadContext(thread);
        if (Boolean.TRUE.equals(user.getIsAdmin())) {
            return;
        }
        EntityReference owner = Entity.getOwner(aboutRef);
        List assignees = thread.getTask().getAssignees();
        if (owner != null && (owner.getName().equals(userName) || closeTask && thread.getCreatedBy().equals(userName))) {
            return;
        }
        if (assignees.stream().anyMatch(assignee -> assignee.getName().equals(userName))) {
            ResourceContext resourceContext = new ResourceContext(aboutRef.getType(), aboutRef.getId(), null);
            if (EntityUtil.isDescriptionTask(threadContext.getTaskWorkflow().getTaskType())) {
                OperationContext operationContext = new OperationContext(aboutRef.getType(), MetadataOperation.EDIT_DESCRIPTION);
                authorizer.authorize(securityContext, operationContext, resourceContext);
            } else if (EntityUtil.isTagTask(threadContext.getTaskWorkflow().getTaskType())) {
                OperationContext operationContext = new OperationContext(aboutRef.getType(), MetadataOperation.EDIT_TAGS);
                authorizer.authorize(securityContext, operationContext, resourceContext);
            }
            return;
        }
        List teams = user.getTeams();
        List<String> teamNames = teams.stream().map(EntityReference::getName).toList();
        if (assignees.stream().anyMatch(assignee -> teamNames.contains(assignee.getName())) || teamNames.contains(owner.getName())) {
            return;
        }
        throw new AuthorizationException(CatalogExceptionMessage.taskOperationNotAllowed(userName, closeTask ? "closeTask" : "resolveTask"));
    }

    private void validateAnnouncement(Thread thread) {
        long endTime;
        long startTime = thread.getAnnouncement().getStartTime();
        if (startTime >= (endTime = thread.getAnnouncement().getEndTime().longValue())) {
            throw new IllegalArgumentException("Announcement start time must be earlier than the end time");
        }
        List<String> announcements = this.dao.feedDAO().listAnnouncementBetween(thread.getId(), thread.getEntityId(), startTime, endTime);
        if (!announcements.isEmpty()) {
            throw new IllegalArgumentException("There is already an announcement scheduled that overlaps with the given start time and end time");
        }
    }

    private void validateAssignee(Thread thread) {
        if (thread != null && ThreadType.Task.equals((Object)thread.getType())) {
            String createdByUserName = thread.getCreatedBy();
            User createdByUser = (User)Entity.getEntityByName("user", createdByUserName, "teams", Include.NON_DELETED);
            if (Boolean.TRUE.equals(createdByUser.getIsBot())) {
                throw new IllegalArgumentException("Task cannot be created by bot only by user or teams");
            }
            List assignees = thread.getTask().getAssignees();
            assignees.forEach(assignee -> {
                if (!assignee.getType().equals("user") && !assignee.getType().equals("team")) {
                    throw new IllegalArgumentException("Assignees can only be user or teams");
                }
            });
            for (EntityReference ref : assignees) {
                User user;
                EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(ref.getType());
                if (!ref.getType().equals("user") || !Boolean.TRUE.equals((user = (User)repository.get(null, ref.getId(), repository.getFields("id"))).getIsBot())) continue;
                throw new IllegalArgumentException("Assignees can not be bot");
            }
        }
    }

    private void restorePatchAttributes(Thread original, Thread updated) {
        updated.withId(original.getId()).withAbout(original.getAbout()).withType(original.getType());
    }

    private void restorePatchAttributes(Post original, Post updated) {
        updated.withId(original.getId()).withPostTs(original.getPostTs()).withFrom(original.getFrom());
    }

    private void populateUserReactions(List<Reaction> reactions) {
        if (!Collections.isEmpty(reactions)) {
            reactions.forEach(reaction -> reaction.setUser(Entity.getEntityReferenceById("user", reaction.getUser().getId(), Include.ALL)));
        }
    }

    private boolean patchUpdate(Thread original, Thread updated) {
        if (this.fieldsChanged(original, updated)) {
            this.populateUserReactions(updated.getReactions());
            this.dao.feedDAO().update(updated.getId(), JsonUtils.pojoToJson(updated));
            return true;
        }
        return false;
    }

    private boolean patchUpdate(Thread thread, Post originalPost, Post updatedPost) {
        if (this.fieldsChanged(originalPost, updatedPost)) {
            this.dao.feedDAO().update(thread.getId(), JsonUtils.pojoToJson(thread));
            return true;
        }
        return false;
    }

    private boolean fieldsChanged(Post original, Post updated) {
        return !original.getMessage().equals(updated.getMessage()) || Collections.isEmpty((Collection)original.getReactions()) && !Collections.isEmpty((Collection)updated.getReactions()) || !Collections.isEmpty((Collection)original.getReactions()) && Collections.isEmpty((Collection)updated.getReactions()) || original.getReactions().size() != updated.getReactions().size() || !original.getReactions().containsAll(updated.getReactions());
    }

    private boolean fieldsChanged(Thread original, Thread updated) {
        return !original.getResolved().equals(updated.getResolved()) || !original.getMessage().equals(updated.getMessage()) || Collections.isEmpty((Collection)original.getReactions()) && !Collections.isEmpty((Collection)updated.getReactions()) || !Collections.isEmpty((Collection)original.getReactions()) && Collections.isEmpty((Collection)updated.getReactions()) || original.getReactions() != null && updated.getReactions() != null && (original.getReactions().size() != updated.getReactions().size() || !original.getReactions().containsAll(updated.getReactions())) || original.getAnnouncement() != null && (!original.getAnnouncement().getDescription().equals(updated.getAnnouncement().getDescription()) || !Objects.equals(original.getAnnouncement().getStartTime(), updated.getAnnouncement().getStartTime()) || !Objects.equals(original.getAnnouncement().getEndTime(), updated.getAnnouncement().getEndTime())) || original.getChatbot() == null && updated.getChatbot() != null || original.getChatbot() != null && updated.getChatbot() != null && !original.getChatbot().getQuery().equals(updated.getChatbot().getQuery()) || original.getTask() != null && (original.getTask().getAssignees().size() != updated.getTask().getAssignees().size() || !original.getTask().getAssignees().containsAll(updated.getTask().getAssignees()));
    }

    private void sortPosts(Thread thread) {
        thread.getPosts().sort(Comparator.comparing(Post::getPostTs));
    }

    private void sortPostsInThreads(List<Thread> threads) {
        threads.forEach(this::sortPosts);
    }

    private void sortAndLimitPosts(List<Thread> threads, int limitPosts) {
        for (Thread t : threads) {
            List posts = t.getPosts();
            this.sortPosts(t);
            if (posts.size() <= limitPosts) continue;
            posts = posts.subList(posts.size() - limitPosts, posts.size());
            t.withPosts(posts);
        }
    }

    private String getUserTeamJsonMysql(UUID userId, List<String> teamIds) {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        result.add((CallSite)((Object)("\"" + userId.toString() + "\"")));
        teamIds.forEach(id -> result.add((CallSite)((Object)("\"" + id + "\""))));
        return ((Object)result).toString();
    }

    private List<String> getUserTeamJsonPostgres(UUID userId, List<String> teamIds) {
        ArrayList<String> result = new ArrayList<String>();
        JSONObject json = this.getUserTeamJson(userId, "user");
        result.add(List.of(json.toString()).toString());
        teamIds.forEach(id -> result.add(List.of(this.getUserTeamJson((String)id, "team").toString()).toString()));
        return result;
    }

    private JSONObject getUserTeamJson(UUID userId, String type) {
        return new JSONObject().put("id", (Object)userId).put("type", (Object)type);
    }

    private JSONObject getUserTeamJson(String userId, String type) {
        return new JSONObject().put("id", (Object)userId).put("type", (Object)type);
    }

    private FilteredThreads getTasksAssignedTo(FeedFilter filter, UUID userId, int limit) {
        List<String> teamIds = this.getTeamIds(userId);
        List<String> userTeamJsonPostgres = this.getUserTeamJsonPostgres(userId, teamIds);
        String userTeamJsonMysql = this.getUserTeamJsonMysql(userId, teamIds);
        List<String> jsons = this.dao.feedDAO().listTasksAssigned(userTeamJsonPostgres, userTeamJsonMysql, limit, filter.getCondition());
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountTasksAssignedTo(userTeamJsonPostgres, userTeamJsonMysql, filter.getCondition(false));
        return new FilteredThreads(threads, totalCount);
    }

    private void populateAssignees(List<Thread> threads) {
        threads.forEach(this::populateAssignees);
    }

    private Thread populateAssignees(Thread thread) {
        if (thread != null && ThreadType.Task.equals((Object)thread.getType())) {
            List assignees = thread.getTask().getAssignees();
            for (EntityReference ref : assignees) {
                try {
                    EntityReference ref2 = Entity.getEntityReferenceById(ref.getType(), ref.getId(), Include.ALL);
                    EntityUtil.copy(ref2, ref);
                }
                catch (EntityNotFoundException exception) {
                    if (ref.getType().equals("team")) {
                        ref.setName(DELETED_TEAM_NAME);
                        ref.setDisplayName(DELETED_TEAM_DISPLAY);
                        continue;
                    }
                    ref.setName(DELETED_USER_NAME);
                    ref.setDisplayName(DELETED_USER_DISPLAY);
                }
            }
            assignees.sort(EntityUtil.compareEntityReference);
            thread.getTask().setAssignees(assignees);
        }
        return thread;
    }

    private FilteredThreads getTasksOfUser(FeedFilter filter, UUID userId, int limit) {
        String username = Entity.getEntityReferenceById("user", userId, Include.NON_DELETED).getName();
        List<String> teamIds = this.getTeamIds(userId);
        List<String> userTeamJsonPostgres = this.getUserTeamJsonPostgres(userId, teamIds);
        String userTeamJsonMysql = this.getUserTeamJsonMysql(userId, teamIds);
        List<String> jsons = this.dao.feedDAO().listTasksOfUser(userTeamJsonPostgres, userTeamJsonMysql, username, limit, filter.getCondition());
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountTasksOfUser(userTeamJsonPostgres, userTeamJsonMysql, username, filter.getCondition(false));
        return new FilteredThreads(threads, totalCount);
    }

    private FilteredThreads getTasksAssignedBy(FeedFilter filter, UUID userId, int limit) {
        String username = Entity.getEntityReferenceById("user", userId, Include.NON_DELETED).getName();
        List<String> jsons = this.dao.feedDAO().listTasksAssigned(username, limit, filter.getCondition());
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountTasksAssignedBy(username, filter.getCondition(false));
        return new FilteredThreads(threads, totalCount);
    }

    private FilteredThreads getThreadsByOwner(FeedFilter filter, UUID userId, int limit) {
        List<String> teamIds = this.getTeamIds(userId);
        List<String> jsons = this.dao.feedDAO().listThreadsByOwner(userId, teamIds, limit, filter.getCondition());
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountThreadsByOwner(userId, teamIds, filter.getCondition(false));
        return new FilteredThreads(threads, totalCount);
    }

    private FilteredThreads getThreadsByMentions(FeedFilter filter, UUID userId, int limit) {
        User user = (User)Entity.getEntity("user", userId, "teams", Include.NON_DELETED);
        String userNameHash = this.getUserNameHash(user);
        List<String> teamNamesHash = this.getTeamNames(user);
        List<String> jsons = this.dao.feedDAO().listThreadsByMentions(userNameHash, teamNamesHash, limit, Relationship.MENTIONED_IN.ordinal(), filter.getCondition());
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountThreadsByMentions(userNameHash, teamNamesHash, Relationship.MENTIONED_IN.ordinal(), filter.getCondition(false));
        return new FilteredThreads(threads, totalCount);
    }

    private List<String> getTeamIds(UUID userId) {
        List<String> teamIds = null;
        if (userId != null) {
            User user = (User)Entity.getEntity("user", userId, "teams", Include.NON_DELETED);
            teamIds = this.getTeamIds(user);
        }
        return CommonUtil.nullOrEmpty(teamIds) ? List.of("") : teamIds;
    }

    private List<String> getTeamIds(User user) {
        List<String> teamIds = CommonUtil.listOrEmpty((List)user.getTeams()).stream().map(ref -> ref.getId().toString()).toList();
        return CommonUtil.nullOrEmpty(teamIds) ? List.of("") : teamIds;
    }

    private FilteredThreads getThreadsByFollows(FeedFilter filter, UUID userId, int limit) {
        List<String> teamIds = this.getTeamIds(userId);
        List<String> jsons = this.dao.feedDAO().listThreadsByFollows(userId, teamIds, limit, Relationship.FOLLOWS.ordinal(), filter.getCondition());
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountThreadsByFollows(userId, teamIds, Relationship.FOLLOWS.ordinal(), filter.getCondition());
        return new FilteredThreads(threads, totalCount);
    }

    private FilteredThreads getThreadsByOwnerOrFollows(FeedFilter filter, UUID userId, int limit) {
        List<String> teamIds = this.getTeamIds(userId);
        List<String> jsons = this.dao.feedDAO().listThreadsByOwnerOrFollows(userId, teamIds, limit, filter.getCondition());
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountThreadsByOwnerOrFollows(userId, teamIds, filter.getCondition());
        return new FilteredThreads(threads, totalCount);
    }

    private List<String> getTeamNames(User user) {
        List<String> teamNames = null;
        if (user != null) {
            teamNames = CommonUtil.listOrEmpty((List)user.getTeams()).stream().map(x -> FullyQualifiedName.buildHash(x.getFullyQualifiedName())).toList();
        }
        return CommonUtil.nullOrEmpty(teamNames) ? List.of("") : teamNames;
    }

    private String getUserNameHash(User user) {
        return user != null ? FullyQualifiedName.buildHash(user.getFullyQualifiedName()) : null;
    }

    public static String resolveDescriptionTaskMessage(TaskDetails task) {
        return String.format("Resolved the Task with Description - %s", FEED_MESSAGE_FORMATTER.getPlaintextDiff(task.getOldValue(), task.getNewValue()));
    }

    public static String resolveTagTaskMessage(TaskDetails task) {
        String oldValue = task.getOldValue() != null ? FeedRepository.getTagFQNs(JsonUtils.readObjects(task.getOldValue(), TagLabel.class)) : "";
        String newValue = FeedRepository.getTagFQNs(JsonUtils.readObjects(task.getNewValue(), TagLabel.class));
        return String.format("Resolved the Task with Tag(s) - %s", FEED_MESSAGE_FORMATTER.getPlaintextDiff(oldValue, newValue));
    }

    public static String closeTaskMessage(String closingComment) {
        return String.format("Closed the Task with comment - %s", closingComment);
    }

    public static class ThreadContext {
        protected final Thread thread;
        protected MessageParser.EntityLink about;
        protected EntityInterface aboutEntity;
        private final EntityReference createdBy;

        ThreadContext(Thread thread) {
            this.thread = thread;
            this.about = MessageParser.EntityLink.parse(thread.getAbout());
            this.aboutEntity = (EntityInterface)Entity.getEntity(this.about, this.getFields(), Include.ALL);
            this.createdBy = Entity.getEntityReferenceByName("user", thread.getCreatedBy(), Include.NON_DELETED);
            thread.withEntityId(this.aboutEntity.getId());
        }

        ThreadContext(Thread thread, ChangeEvent event) {
            this.thread = thread;
            this.about = MessageParser.EntityLink.parse(thread.getAbout());
            if (event.getEventType().equals((Object)EventType.ENTITY_DELETED)) {
                String json = (String)event.getEntity();
                this.aboutEntity = JsonUtils.readValue(json, Entity.getEntityClassFromType(event.getEntityType()));
            } else {
                this.aboutEntity = (EntityInterface)Entity.getEntity(this.about, this.getFields(), Include.ALL);
            }
            this.createdBy = Entity.getEntityReferenceByName("user", thread.getCreatedBy(), Include.NON_DELETED);
            thread.withEntityId(this.aboutEntity.getId());
        }

        public TaskWorkflow getTaskWorkflow() {
            EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(this.about.getEntityType());
            return repository.getTaskWorkflow(this);
        }

        public EntityRepository<? extends EntityInterface> getEntityRepository() {
            return Entity.getEntityRepository(this.about.getEntityType());
        }

        private String getFields() {
            EntityRepository<? extends EntityInterface> repository = this.getEntityRepository();
            ArrayList<String> fieldList = new ArrayList<String>();
            if (repository.supportsOwner) {
                fieldList.add("owner");
            }
            if (repository.supportsTags) {
                fieldList.add("tags");
            }
            return String.join((CharSequence)",", fieldList.toArray(new String[0]));
        }

        public Thread getThread() {
            return this.thread;
        }

        public MessageParser.EntityLink getAbout() {
            return this.about;
        }

        public EntityInterface getAboutEntity() {
            return this.aboutEntity;
        }

        public EntityReference getCreatedBy() {
            return this.createdBy;
        }

        public void setAbout(MessageParser.EntityLink about) {
            this.about = about;
        }

        public void setAboutEntity(EntityInterface aboutEntity) {
            this.aboutEntity = aboutEntity;
        }
    }

    public static abstract class TaskWorkflow {
        protected final ThreadContext threadContext;

        TaskWorkflow(ThreadContext threadContext) {
            this.threadContext = threadContext;
        }

        public abstract EntityInterface performTask(String var1, ResolveTask var2);

        protected void closeTask(String user, CloseTask closeTask) {
        }

        protected final TaskType getTaskType() {
            return this.threadContext.getThread().getTask().getType();
        }

        protected final MessageParser.EntityLink getAbout() {
            return this.threadContext.getAbout();
        }
    }

    public record FilteredThreads(List<Thread> threads, int totalCount) {
    }

    public static enum FilterType {
        OWNER,
        MENTIONS,
        FOLLOWS,
        ASSIGNED_TO,
        ASSIGNED_BY,
        OWNER_OR_FOLLOWS;

    }

    public static enum PaginationType {
        BEFORE,
        AFTER;

    }
}

