/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class DashboardIndex
implements SearchIndex {
    final Dashboard dashboard;

    public DashboardIndex(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.dashboard.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.dashboard.getDisplayName()).weight(10).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.dashboard;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> chartSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> dataModelSuggest = new ArrayList<SearchSuggest>();
        serviceSuggest.add(SearchSuggest.builder().input(this.dashboard.getService().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("dashboard", (EntityInterface)this.dashboard));
        for (EntityReference chart : CommonUtil.listOrEmpty((List)this.dashboard.getCharts())) {
            chartSuggest.add(SearchSuggest.builder().input(chart.getDisplayName()).weight(5).build());
        }
        for (EntityReference chart : CommonUtil.listOrEmpty((List)this.dashboard.getDataModels())) {
            dataModelSuggest.add(SearchSuggest.builder().input(chart.getDisplayName()).weight(5).build());
        }
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.dashboard, "dashboard");
        doc.putAll(commonAttributes);
        doc.put("displayName", this.dashboard.getDisplayName() != null ? this.dashboard.getDisplayName() : this.dashboard.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("chart_suggest", chartSuggest);
        doc.put("data_model_suggest", dataModelSuggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("serviceType", this.dashboard.getServiceType());
        doc.put("lineage", SearchIndex.getLineageData(this.dashboard.getEntityReference()));
        doc.put("service", this.getEntityWithDisplayName(this.dashboard.getService()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("charts.name", Float.valueOf(2.0f));
        fields.put("charts.description", Float.valueOf(1.0f));
        return fields;
    }
}

