/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.common.utils.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CatalogSecurityContext(Principal principal, String scheme, String authenticationScheme, Set<String> userRoles) implements SecurityContext
{
    private static final Logger LOG = LoggerFactory.getLogger(CatalogSecurityContext.class);
    public static final String OPENID_AUTH = "openid";

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public Set<String> getUserRoles() {
        if (CommonUtil.nullOrEmpty(this.userRoles)) {
            return new HashSet<String>();
        }
        return this.userRoles;
    }

    public boolean isUserInRole(String role) {
        LOG.debug("isUserInRole user: {}, role: {}", (Object)this.principal, (Object)role);
        return false;
    }

    public boolean isSecure() {
        return "https".equals(this.scheme);
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    @Override
    public String toString() {
        return String.format("catalogSecurityContext{principal=%s, scheme='%s', authenticationSchema='%s', isSecure=%s}", this.principal, this.scheme, this.authenticationScheme, this.isSecure());
    }
}

