/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util.jdbi;

import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;
import org.openmetadata.service.util.MicrometerBundleSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMSqlLogger
implements SqlLogger {
    private static final Logger LOG = LoggerFactory.getLogger(OMSqlLogger.class);

    public void logBeforeExecution(StatementContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sql {}, parameters {}", (Object)context.getRenderedSql(), (Object)context.getBinding());
        }
    }

    public void logAfterExecution(StatementContext context) {
        long elapsedTime = context.getElapsedTime(ChronoUnit.SECONDS);
        MicrometerBundleSingleton.jdbiRequests.observe((double)elapsedTime);
        MicrometerBundleSingleton.getJdbiLatencyTimer().record(elapsedTime, TimeUnit.SECONDS);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sql {}, parameters {}, timeTaken {} ms", new Object[]{context.getRenderedSql(), context.getBinding(), context.getElapsedTime(ChronoUnit.MILLIS)});
        }
    }
}

