/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent;

import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.entity.events.SubscriptionStatus;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.AlertUtil;

public interface Destination<T> {
    public void sendMessage(T var1) throws EventPublisherException;

    public SubscriptionDestination getSubscriptionDestination();

    public void close();

    public boolean getEnabled();

    default public void setErrorStatus(Long attemptTime, Integer statusCode, String reason) {
        this.setStatus(SubscriptionStatus.Status.FAILED, attemptTime, statusCode, reason, null);
    }

    default public void setAwaitingRetry(Long attemptTime, int statusCode, String reason) {
        this.setStatus(SubscriptionStatus.Status.AWAITING_RETRY, attemptTime, statusCode, reason, attemptTime + 10L);
    }

    default public void setSuccessStatus(Long updateTime) {
        SubscriptionStatus subStatus = AlertUtil.buildSubscriptionStatus(SubscriptionStatus.Status.ACTIVE, updateTime, null, null, null, updateTime, updateTime);
        this.getSubscriptionDestination().setStatusDetails(subStatus);
    }

    default public void setStatus(SubscriptionStatus.Status status, Long attemptTime, Integer statusCode, String reason, Long timestamp) {
        SubscriptionStatus subStatus = AlertUtil.buildSubscriptionStatus(status, null, attemptTime, statusCode, reason, timestamp, attemptTime);
        this.getSubscriptionDestination().setStatusDetails(subStatus);
    }
}

