/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import org.openmetadata.schema.entity.feed.DomainFeedInfo;
import org.openmetadata.schema.entity.feed.FeedInfo;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.util.JsonUtils;

public class DomainFormatter
extends DefaultFieldFormatter {
    private static final String HEADER_MESSAGE = "%s %s asset %s in Domain %s";

    public DomainFormatter(MessageDecorator<?> messageDecorator, Thread thread, FieldChange fieldChange) {
        super(messageDecorator, thread, fieldChange);
    }

    @Override
    public String formatAddedField() {
        String message = super.formatAddedField();
        this.populateDomainFeedInfo(Thread.FieldOperation.ADDED, message);
        return message;
    }

    @Override
    public String formatUpdatedField() {
        String message = super.formatUpdatedField();
        this.populateDomainFeedInfo(Thread.FieldOperation.UPDATED, message);
        return message;
    }

    @Override
    public String formatDeletedField() {
        String message = super.formatDeletedField();
        this.populateDomainFeedInfo(Thread.FieldOperation.DELETED, message);
        return message;
    }

    private void populateDomainFeedInfo(Thread.FieldOperation operation, String threadMessage) {
        DomainFeedInfo domainFeedInfo = new DomainFeedInfo().withPreviousDomain(JsonUtils.readOrConvertValue(this.fieldChange.getOldValue(), EntityReference.class)).withUpdatedDomain(JsonUtils.readOrConvertValue(this.fieldChange.getNewValue(), EntityReference.class));
        FeedInfo feedInfo = new FeedInfo().withHeaderMessage(this.getHeaderForOwnerUpdate(operation.value(), this.messageDecorator.getEntityUrl("domain", domainFeedInfo.getUpdatedDomain().getFullyQualifiedName(), ""))).withFieldName("domain").withEntitySpecificInfo((Object)domainFeedInfo);
        DomainFormatter.populateThreadFeedInfo(this.thread, threadMessage, Thread.CardStyle.DOMAIN, operation, feedInfo);
    }

    private String getHeaderForOwnerUpdate(String eventTypeMessage, String domainUrl) {
        return String.format(HEADER_MESSAGE, this.thread.getUpdatedBy(), eventTypeMessage, this.thread.getEntityUrlLink(), domainUrl);
    }
}

