/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.CloseTask;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.ResultSummary;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestCaseParameter;
import org.openmetadata.schema.tests.TestCaseParameterValidationRule;
import org.openmetadata.schema.tests.TestCaseParameterValue;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.tests.type.Resolved;
import org.openmetadata.schema.tests.type.TestCaseFailureReasonType;
import org.openmetadata.schema.tests.type.TestCaseResolutionStatus;
import org.openmetadata.schema.tests.type.TestCaseResolutionStatusTypes;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TableData;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.TestCaseParameterValidationRuleType;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.jdbi3.TestCaseResolutionStatusRepository;
import org.openmetadata.service.jdbi3.TestSuiteRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.mask.PIIMasker;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseRepository
extends EntityRepository<TestCase> {
    private static final Logger LOG = LoggerFactory.getLogger(TestCaseRepository.class);
    private static final String TEST_SUITE_FIELD = "testSuite";
    private static final String TEST_CASE_RESULT_FIELD = "testCaseResult";
    private static final String INCIDENTS_FIELD = "incidentId";
    public static final String COLLECTION_PATH = "/v1/dataQuality/testCases";
    private static final String UPDATE_FIELDS = "owner,entityLink,testSuite,testSuites,testDefinition";
    private static final String PATCH_FIELDS = "owner,entityLink,testSuite,testDefinition,computePassedFailedRowCount";
    public static final String TESTCASE_RESULT_EXTENSION = "testCase.testCaseResult";
    public static final String FAILED_ROWS_SAMPLE_EXTENSION = "testCase.failedRowsSample";

    public TestCaseRepository() {
        super(COLLECTION_PATH, "testCase", TestCase.class, Entity.getCollectionDAO().testCaseDAO(), PATCH_FIELDS, UPDATE_FIELDS);
        this.supportsSearch = true;
    }

    @Override
    public void setFields(TestCase test, EntityUtil.Fields fields) {
        test.setTestSuites(fields.contains("testSuites") ? this.getTestSuites(test) : test.getTestSuites());
        test.setTestSuite(fields.contains(TEST_SUITE_FIELD) ? this.getTestSuite(test) : test.getTestSuite());
        test.setTestDefinition(fields.contains("testDefinition") ? this.getTestDefinition(test) : test.getTestDefinition());
        test.setTestCaseResult(fields.contains(TEST_CASE_RESULT_FIELD) ? this.getTestCaseResult(test) : test.getTestCaseResult());
        test.setIncidentId(fields.contains(INCIDENTS_FIELD) ? this.getIncidentId(test) : test.getIncidentId());
        test.setTags(fields.contains("tags") ? this.getTestCaseTags(test) : test.getTags());
    }

    @Override
    public void setInheritedFields(TestCase testCase, EntityUtil.Fields fields) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(testCase.getEntityLink());
        Table table = (Table)Entity.getEntity(entityLink, "owner,domain,tags,columns", Include.ALL);
        this.inheritOwner(testCase, fields, (EntityInterface)table);
        this.inheritDomain(testCase, fields, (EntityInterface)table);
        this.inheritTags(testCase, fields, table);
    }

    private void inheritTags(TestCase testCase, EntityUtil.Fields fields, Table table) {
        if (fields.contains("tags")) {
            ArrayList tags = new ArrayList();
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(testCase.getEntityLink());
            tags.addAll(table.getTags());
            if (entityLink.getFieldName() != null && entityLink.getFieldName().equals("columns")) {
                table.getColumns().stream().filter(column -> column.getName().equals(entityLink.getArrayFieldName())).findFirst().ifPresent(column -> tags.addAll(column.getTags()));
            }
            testCase.setTags(tags);
        }
    }

    @Override
    public EntityInterface getParentEntity(TestCase entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getTestSuite(), fields, Include.NON_DELETED);
    }

    @Override
    public void clearFields(TestCase test, EntityUtil.Fields fields) {
        test.setTestSuites(fields.contains("testSuites") ? test.getTestSuites() : null);
        test.setTestSuite(fields.contains(TEST_SUITE_FIELD) ? test.getTestSuite() : null);
        test.setTestDefinition(fields.contains("testDefinition") ? test.getTestDefinition() : null);
        test.setTestCaseResult(fields.contains(TEST_CASE_RESULT_FIELD) ? test.getTestCaseResult() : null);
    }

    public RestUtil.PatchResponse<TestCaseResult> patchTestCaseResults(String fqn, Long timestamp, JsonPatch patch) {
        TestCaseResult updated;
        TestCaseResult original = JsonUtils.readValue(this.daoCollection.dataQualityDataTimeSeriesDao().getExtensionAtTimestamp(fqn, TESTCASE_RESULT_EXTENSION, timestamp), TestCaseResult.class);
        if (!Objects.equals(original, updated = JsonUtils.applyPatch(original, patch, TestCaseResult.class))) {
            TestCase testCase = (TestCase)Entity.getEntityByName("testCase", fqn, "testDefinition,testSuites", Include.NON_DELETED);
            this.setTestCaseResult(testCase, updated, false);
        }
        return new RestUtil.PatchResponse<TestCaseResult>(Response.Status.OK, updated, EventType.ENTITY_NO_CHANGE);
    }

    @Override
    public void setFullyQualifiedName(TestCase test) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
        test.setFullyQualifiedName(FullyQualifiedName.add(entityLink.getFullyQualifiedFieldValue(), EntityInterfaceUtil.quoteName((String)test.getName())));
        test.setEntityFQN(entityLink.getFullyQualifiedFieldValue());
    }

    @Override
    public void prepare(TestCase test, boolean update) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
        EntityUtil.validateEntityLink(entityLink);
        TestSuite testSuite = (TestSuite)Entity.getEntity(test.getTestSuite(), "", Include.NON_DELETED);
        test.setTestSuite(testSuite.getEntityReference());
        TestDefinition testDefinition = (TestDefinition)Entity.getEntity(test.getTestDefinition(), "", Include.NON_DELETED);
        test.setTestDefinition(testDefinition.getEntityReference());
        this.validateTestParameters(test.getParameterValues(), testDefinition.getParameterDefinition());
    }

    private EntityReference getTestSuite(TestCase test) throws EntityNotFoundException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFromRecords(test.getId(), this.entityType, Relationship.CONTAINS, TEST_SUITE_FIELD);
        for (CollectionDAO.EntityRelationshipRecord testSuiteId : records) {
            TestSuite testSuite = (TestSuite)Entity.getEntity(TEST_SUITE_FIELD, testSuiteId.getId(), "", Include.ALL);
            if (!Boolean.TRUE.equals(testSuite.getExecutable())) continue;
            return testSuite.getEntityReference();
        }
        throw new EntityNotFoundException(String.format("Error occurred when retrieving executable test suite for testCase %s. ", test.getName()) + "No executable test suite was found.");
    }

    private List<TestSuite> getTestSuites(TestCase test) {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFromRecords(test.getId(), this.entityType, Relationship.CONTAINS, TEST_SUITE_FIELD);
        return records.stream().map(testSuiteId -> (TestSuite)Entity.getEntity(TEST_SUITE_FIELD, testSuiteId.getId(), "", Include.ALL, false)).toList();
    }

    private EntityReference getTestDefinition(TestCase test) {
        return this.getFromEntityRef(test.getId(), Relationship.CONTAINS, "testDefinition", true);
    }

    private void validateTestParameters(List<TestCaseParameterValue> parameterValues, List<TestCaseParameter> parameterDefinition) {
        if (parameterValues != null) {
            if (parameterDefinition.isEmpty() && !parameterValues.isEmpty()) {
                throw new IllegalArgumentException("Parameter Values doesn't match Test Definition Parameters");
            }
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (TestCaseParameterValue testCaseParameterValue : parameterValues) {
                values.put(testCaseParameterValue.getName(), testCaseParameterValue.getValue());
            }
            for (TestCaseParameter parameter : parameterDefinition) {
                if (Boolean.TRUE.equals(parameter.getRequired()) && (!values.containsKey(parameter.getName()) || values.get(parameter.getName()) == null)) {
                    throw new IllegalArgumentException("Required parameter " + parameter.getName() + " is not passed in parameterValues");
                }
                this.validateParameterRule(parameter, values);
            }
        }
    }

    @Override
    public void storeEntity(TestCase test, boolean update) {
        EntityReference testSuite = test.getTestSuite();
        EntityReference testDefinition = test.getTestDefinition();
        test.withTestSuite(null).withTestDefinition(null);
        this.store(test, update);
        test.withTestSuite(testSuite).withTestDefinition(testDefinition);
    }

    @Override
    public void storeRelationships(TestCase test) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
        EntityUtil.validateEntityLink(entityLink);
        this.addRelationship(test.getTestSuite().getId(), test.getId(), TEST_SUITE_FIELD, "testCase", Relationship.CONTAINS);
        this.addRelationship(test.getTestDefinition().getId(), test.getId(), "testDefinition", "testCase", Relationship.CONTAINS);
    }

    @Override
    protected void postDelete(TestCase test) {
        List testSuites = test.getTestSuites();
        if (!testSuites.isEmpty()) {
            for (TestSuite testSuite : testSuites) {
                this.removeTestCaseFromTestSuiteResultSummary(testSuite.getId(), test.getFullyQualifiedName());
            }
        }
        this.deleteTestCaseFailedRowsSample(test.getId());
    }

    @Override
    protected void postCreate(TestCase test) {
        super.postCreate(test);
        TestSuiteRepository testSuiteRepository = (TestSuiteRepository)Entity.getEntityRepository(TEST_SUITE_FIELD);
        TestSuite testSuite = (TestSuite)Entity.getEntity(test.getTestSuite(), "*", Include.ALL);
        TestSuite original = TestSuiteRepository.copyTestSuite(testSuite);
        testSuiteRepository.postUpdate(original, testSuite);
    }

    public RestUtil.PutResponse<TestCaseResult> addTestCaseResult(String updatedBy, UriInfo uriInfo, String fqn, TestCaseResult testCaseResult) {
        TestCase testCase = (TestCase)this.findByName(fqn, Include.NON_DELETED);
        ArrayList<String> fields = new ArrayList<String>(List.of("testDefinition", "owner", "tags", TEST_SUITE_FIELD, "testSuites"));
        UUID incidentStateId = null;
        if (TestCaseStatus.Failed.equals((Object)testCaseResult.getTestCaseStatus())) {
            incidentStateId = this.getOrCreateIncidentOnFailure(testCase, updatedBy);
            testCaseResult.setIncidentId(incidentStateId);
            fields.add(INCIDENTS_FIELD);
        } else {
            testCase.setIncidentId(null);
        }
        this.daoCollection.dataQualityDataTimeSeriesDao().insert(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION, TEST_CASE_RESULT_FIELD, JsonUtils.pojoToJson(testCaseResult), incidentStateId != null ? incidentStateId.toString() : null);
        this.setFieldsInternal(testCase, new EntityUtil.Fields((Set<String>)this.allowedFields, (Set<String>)ImmutableSet.copyOf(fields)));
        this.setTestSuiteSummary(testCase, testCaseResult.getTimestamp(), testCaseResult.getTestCaseStatus(), false);
        this.setTestCaseResult(testCase, testCaseResult, false);
        ChangeDescription change = this.addTestCaseChangeDescription(testCase.getVersion(), testCaseResult);
        ChangeEvent changeEvent = this.getChangeEvent(updatedBy, (EntityInterface)this.withHref(uriInfo, testCase), change, this.entityType, testCase.getVersion());
        return new RestUtil.PutResponse<TestCaseResult>(Response.Status.CREATED, changeEvent, EventType.ENTITY_FIELDS_CHANGED);
    }

    private UUID getOrCreateIncidentOnFailure(TestCase testCase, String updatedBy) {
        TestCaseResolutionStatus storedTestCaseResolutionStatus;
        TestCaseResolutionStatusRepository testCaseResolutionStatusRepository = (TestCaseResolutionStatusRepository)Entity.getEntityTimeSeriesRepository("testCaseResolutionStatus");
        String json = this.daoCollection.testCaseResolutionStatusTimeSeriesDao().getLatestRecord(testCase.getFullyQualifiedName());
        TestCaseResolutionStatus testCaseResolutionStatus = storedTestCaseResolutionStatus = json != null ? JsonUtils.readValue(json, TestCaseResolutionStatus.class) : null;
        if (Boolean.TRUE.equals(testCaseResolutionStatusRepository.unresolvedIncident(storedTestCaseResolutionStatus))) {
            return storedTestCaseResolutionStatus.getStateId();
        }
        TestCaseResolutionStatus status = new TestCaseResolutionStatus().withStateId(UUID.randomUUID()).withTimestamp(Long.valueOf(System.currentTimeMillis())).withTestCaseResolutionStatusType(TestCaseResolutionStatusTypes.New).withUpdatedBy(Entity.getEntityReferenceByName("user", updatedBy, Include.ALL)).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withTestCaseReference(testCase.getEntityReference());
        testCaseResolutionStatusRepository.createNewRecord(status, testCase.getFullyQualifiedName());
        TestCaseResolutionStatus incident = (TestCaseResolutionStatus)testCaseResolutionStatusRepository.getLatestRecord(testCase.getFullyQualifiedName());
        return incident.getStateId();
    }

    @Override
    @Transaction
    protected void deleteChildren(List<CollectionDAO.EntityRelationshipRecord> children, boolean hardDelete, String updatedBy) {
        if (hardDelete) {
            for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : children) {
                LOG.info("Recursively {} deleting {} {}", new Object[]{hardDelete ? "hard" : "soft", entityRelationshipRecord.getType(), entityRelationshipRecord.getId()});
                TestCaseResolutionStatusRepository testCaseResolutionStatusRepository = (TestCaseResolutionStatusRepository)Entity.getEntityTimeSeriesRepository("testCaseResolutionStatus");
                for (CollectionDAO.EntityRelationshipRecord child : children) {
                    testCaseResolutionStatusRepository.deleteById(child.getId(), hardDelete);
                }
            }
        }
    }

    public RestUtil.PutResponse<TestCaseResult> deleteTestCaseResult(String updatedBy, String fqn, Long timestamp) {
        TestCase testCase = (TestCase)Entity.getEntityByName("testCase", fqn, "testDefinition,testSuites", Include.NON_DELETED);
        TestCaseResult storedTestCaseResult = JsonUtils.readValue(this.daoCollection.dataQualityDataTimeSeriesDao().getExtensionAtTimestamp(fqn, TESTCASE_RESULT_EXTENSION, timestamp), TestCaseResult.class);
        if (storedTestCaseResult != null) {
            this.daoCollection.dataQualityDataTimeSeriesDao().deleteAtTimestamp(fqn, TESTCASE_RESULT_EXTENSION, timestamp);
            testCase.setTestCaseResult(storedTestCaseResult);
            ChangeDescription change = this.deleteTestCaseChangeDescription(testCase.getVersion(), storedTestCaseResult);
            ChangeEvent changeEvent = this.getChangeEvent(updatedBy, (EntityInterface)testCase, change, this.entityType, testCase.getVersion());
            this.setTestSuiteSummary(testCase, timestamp, storedTestCaseResult.getTestCaseStatus(), true);
            this.setTestCaseResult(testCase, storedTestCaseResult, true);
            return new RestUtil.PutResponse<TestCaseResult>(Response.Status.OK, changeEvent, EventType.ENTITY_FIELDS_CHANGED);
        }
        throw new EntityNotFoundException(String.format("Failed to find testCase result for %s at %s", testCase.getName(), timestamp));
    }

    private ResultSummary getResultSummary(TestCase testCase, Long timestamp, TestCaseStatus testCaseStatus) {
        return new ResultSummary().withTestCaseName(testCase.getFullyQualifiedName()).withStatus(testCaseStatus).withTimestamp(timestamp);
    }

    private void setTestSuiteSummary(TestCase testCase, Long timestamp, TestCaseStatus testCaseStatus, boolean isDeleted) {
        ResultSummary resultSummary = this.getResultSummary(testCase, timestamp, testCaseStatus);
        List<TestSuite> testSuites = this.getTestSuites(testCase);
        for (TestSuite testSuite : testSuites) {
            ResultSummary storedResultSummary;
            testSuite.setSummary(null);
            List resultSummaries = CommonUtil.listOrEmpty((List)testSuite.getTestCaseResultSummary());
            if (isDeleted && resultSummaries.isEmpty() || !this.shouldUpdateResultSummary(storedResultSummary = this.findMatchingResultSummary(resultSummaries, resultSummary.getTestCaseName()), timestamp)) continue;
            if (storedResultSummary != null) {
                resultSummaries.removeIf(summary -> summary.getTestCaseName().equals(resultSummary.getTestCaseName()));
            }
            this.updateResultSummaries(testCase, isDeleted, resultSummaries, resultSummary);
            this.putUpdateTestSuite(testSuite, resultSummaries);
        }
    }

    private void updateResultSummaries(TestCase testCase, boolean isDeleted, List<ResultSummary> resultSummaries, ResultSummary resultSummary) {
        if (!isDeleted) {
            resultSummaries.add(resultSummary);
            return;
        }
        String json = this.daoCollection.dataQualityDataTimeSeriesDao().getLatestExtension(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION);
        if (json != null) {
            TestCaseResult testCaseResult = JsonUtils.readValue(json, TestCaseResult.class);
            ResultSummary newResultSummary = this.getResultSummary(testCase, testCaseResult.getTimestamp(), testCaseResult.getTestCaseStatus());
            resultSummaries.add(newResultSummary);
        }
    }

    private ResultSummary findMatchingResultSummary(List<ResultSummary> resultSummaries, String testCaseNameToMatch) {
        return resultSummaries.stream().filter(summary -> summary.getTestCaseName().equals(testCaseNameToMatch)).findFirst().orElse(null);
    }

    private boolean shouldUpdateResultSummary(ResultSummary storedResultSummary, Long timestamp) {
        return storedResultSummary == null || timestamp >= storedResultSummary.getTimestamp();
    }

    private void setTestCaseResult(TestCase testCase, TestCaseResult testCaseResult, boolean isDeleted) {
        boolean shouldUpdateState = this.compareTestCaseResult(testCase, testCaseResult);
        if (!shouldUpdateState) {
            return;
        }
        if (!isDeleted) {
            testCase.setTestCaseResult(testCaseResult);
        } else {
            TestCaseResult latestTestCaseResult = JsonUtils.readValue(this.daoCollection.dataQualityDataTimeSeriesDao().getLatestExtension(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION), TestCaseResult.class);
            testCase.setTestCaseResult(latestTestCaseResult);
        }
        Map<String, Object> jsonMap = JsonUtils.getMap(testCase);
        jsonMap.remove(TEST_CASE_RESULT_FIELD);
        TestCase original = JsonUtils.readOrConvertValue(jsonMap, TestCase.class);
        EntityRepository.EntityUpdater testCaseUpdater = this.getUpdater(original, testCase, EntityRepository.Operation.PUT);
        testCaseUpdater.update();
    }

    private boolean compareTestCaseResult(TestCase testCase, TestCaseResult testCaseResult) {
        TestCaseResult savedTestCaseResult = testCase.getTestCaseResult();
        if (savedTestCaseResult == null) {
            return true;
        }
        return testCaseResult.getTimestamp() >= savedTestCaseResult.getTimestamp();
    }

    private ChangeDescription addTestCaseChangeDescription(Double version, Object newValue) {
        FieldChange fieldChange = new FieldChange().withName(TEST_CASE_RESULT_FIELD).withNewValue(newValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsAdded().add(fieldChange);
        return change;
    }

    private ChangeDescription deleteTestCaseChangeDescription(Double version, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName(TEST_CASE_RESULT_FIELD).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsDeleted().add(fieldChange);
        return change;
    }

    private ChangeEvent getChangeEvent(String updatedBy, EntityInterface updated, ChangeDescription change, String entityType, Double prevVersion) {
        return new ChangeEvent().withId(UUID.randomUUID()).withEntity((Object)updated).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(entityType).withEntityId(updated.getId()).withEntityFullyQualifiedName(updated.getFullyQualifiedName()).withUserName(updatedBy).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updated.getVersion()).withPreviousVersion(prevVersion);
    }

    private TestCaseResult getTestCaseResult(TestCase testCase) {
        if (testCase.getTestCaseResult() != null) {
            return testCase.getTestCaseResult();
        }
        return JsonUtils.readValue(this.daoCollection.dataQualityDataTimeSeriesDao().getLatestExtension(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION), TestCaseResult.class);
    }

    public ResultList<TestCaseResult> getTestCaseResults(String fqn, Long startTs, Long endTs) {
        List<TestCaseResult> testCaseResults = JsonUtils.readObjects(this.daoCollection.dataQualityDataTimeSeriesDao().listBetweenTimestampsByOrder(fqn, TESTCASE_RESULT_EXTENSION, startTs, endTs, EntityTimeSeriesDAO.OrderBy.DESC), TestCaseResult.class);
        return new ResultList<TestCaseResult>(testCaseResults, String.valueOf(startTs), String.valueOf(endTs), testCaseResults.size());
    }

    private UUID getIncidentId(TestCase test) {
        UUID ongoingIncident = null;
        String json = this.daoCollection.dataQualityDataTimeSeriesDao().getLatestRecord(test.getFullyQualifiedName());
        TestCaseResult latestTestCaseResult = JsonUtils.readValue(json, TestCaseResult.class);
        if (!CommonUtil.nullOrEmpty((Object)latestTestCaseResult)) {
            ongoingIncident = latestTestCaseResult.getIncidentId();
        }
        return ongoingIncident;
    }

    private List<TagLabel> getTestCaseTags(TestCase test) {
        ArrayList<TagLabel> tags = new ArrayList<TagLabel>();
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
        Table table = (Table)Entity.getEntity(entityLink, "tags,columns", Include.ALL);
        tags.addAll(table.getTags());
        if (entityLink.getFieldName() != null && entityLink.getFieldName().equals("columns")) {
            table.getColumns().stream().filter(column -> column.getName().equals(entityLink.getArrayFieldName())).findFirst().ifPresent(column -> tags.addAll(column.getTags()));
        }
        return tags;
    }

    public int getTestCaseCount(List<UUID> testCaseIds) {
        return this.daoCollection.testCaseDAO().countOfTestCases(testCaseIds);
    }

    public void isTestSuiteExecutable(String testSuiteFqn) {
        TestSuite testSuite = (TestSuite)Entity.getEntityByName(TEST_SUITE_FIELD, testSuiteFqn, null, null);
        if (Boolean.FALSE.equals(testSuite.getExecutable())) {
            throw new IllegalArgumentException("Test suite " + testSuite.getName() + " is not executable. Cannot create test cases for non-executable test suites.");
        }
    }

    @Transaction
    public RestUtil.PutResponse<TestSuite> addTestCasesToLogicalTestSuite(TestSuite testSuite, List<UUID> testCaseIds) {
        this.bulkAddToRelationship(testSuite.getId(), testCaseIds, TEST_SUITE_FIELD, "testCase", Relationship.CONTAINS);
        List resultSummaries = CommonUtil.listOrEmpty((List)testSuite.getTestCaseResultSummary());
        for (UUID testCaseId : testCaseIds) {
            TestCase testCase = (TestCase)Entity.getEntity("testCase", testCaseId, "*", Include.ALL);
            this.postUpdate(testCase, testCase);
            String result = this.daoCollection.dataQualityDataTimeSeriesDao().getLatestExtension(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION);
            if (result == null) continue;
            TestCaseResult testCaseResult = JsonUtils.readValue(result, TestCaseResult.class);
            ResultSummary resultSummary = this.getResultSummary(testCase, testCaseResult.getTimestamp(), testCaseResult.getTestCaseStatus());
            resultSummaries.removeIf(summary -> summary.getTestCaseName().equals(resultSummary.getTestCaseName()));
            resultSummaries.add(resultSummary);
        }
        testSuite = (TestSuite)Entity.getEntity(TEST_SUITE_FIELD, testSuite.getId(), "*", Include.ALL, false);
        this.putUpdateTestSuite(testSuite, resultSummaries);
        return new RestUtil.PutResponse<TestSuite>(Response.Status.OK, testSuite, EventType.LOGICAL_TEST_CASE_ADDED);
    }

    @Transaction
    public RestUtil.DeleteResponse<TestCase> deleteTestCaseFromLogicalTestSuite(UUID testSuiteId, UUID testCaseId) {
        TestCase testCase = (TestCase)Entity.getEntity("testCase", testCaseId, null, null);
        this.deleteRelationship(testSuiteId, TEST_SUITE_FIELD, testCaseId, "testCase", Relationship.CONTAINS);
        this.removeTestCaseFromTestSuiteResultSummary(testSuiteId, testCase.getFullyQualifiedName());
        TestCase updatedTestCase = (TestCase)Entity.getEntity("testCase", testCaseId, "*", Include.ALL);
        this.postUpdate(testCase, updatedTestCase);
        testCase.setTestSuite(updatedTestCase.getTestSuite());
        testCase.setTestSuites(updatedTestCase.getTestSuites());
        return new RestUtil.DeleteResponse<TestCase>(testCase, EventType.ENTITY_DELETED);
    }

    @Transaction
    private void removeTestCaseFromTestSuiteResultSummary(UUID testSuiteId, String testCaseFqn) {
        TestSuite testSuite = (TestSuite)Entity.getEntity(TEST_SUITE_FIELD, testSuiteId, "*", Include.ALL, false);
        testSuite.setSummary(null);
        List resultSummaries = testSuite.getTestCaseResultSummary();
        resultSummaries.removeIf(summary -> summary.getTestCaseName().equals(testCaseFqn));
        this.putUpdateTestSuite(testSuite, resultSummaries);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(TestCase original, TestCase updated, EntityRepository.Operation operation) {
        return new TestUpdater(original, updated, operation);
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        TaskType taskType = threadContext.getThread().getTask().getType();
        if (EntityUtil.isTestCaseFailureResolutionTask(taskType)) {
            return new TestCaseFailureResolutionTaskWorkflow(threadContext);
        }
        return super.getTaskWorkflow(threadContext);
    }

    @Transaction
    public TestCase addFailedRowsSample(TestCase testCase, TableData tableData) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(testCase.getEntityLink());
        Table table = (Table)Entity.getEntity(entityLink, "owner", Include.ALL);
        for (String columnName : tableData.getColumns()) {
            TestCaseRepository.validateColumn(table, columnName);
        }
        for (List row : tableData.getRows()) {
            if (row.size() == tableData.getColumns().size()) continue;
            throw new IllegalArgumentException(String.format("Number of columns is %d but row has %d sample values", tableData.getColumns().size(), row.size()));
        }
        this.daoCollection.entityExtensionDAO().insert(testCase.getId(), FAILED_ROWS_SAMPLE_EXTENSION, "failedRowsSample", JsonUtils.pojoToJson(tableData));
        this.setFieldsInternal(testCase, EntityUtil.Fields.EMPTY_FIELDS);
        return testCase.withFailedRowsSample(tableData);
    }

    @Transaction
    public TestCase addInspectionQuery(UriInfo uri, UUID testCaseId, String sql) {
        TestCase original = (TestCase)this.get(uri, testCaseId, this.getFields(PATCH_FIELDS));
        TestCase updated = JsonUtils.readValue(JsonUtils.pojoToJson(original), TestCase.class).withInspectionQuery(sql);
        EntityRepository.EntityUpdater entityUpdater = this.getUpdater(original, updated, EntityRepository.Operation.PATCH);
        entityUpdater.update();
        return updated;
    }

    @Transaction
    public RestUtil.DeleteResponse<TableData> deleteTestCaseFailedRowsSample(UUID id) {
        this.daoCollection.entityExtensionDAO().delete(id, FAILED_ROWS_SAMPLE_EXTENSION);
        return new RestUtil.DeleteResponse<Object>(null, EventType.ENTITY_DELETED);
    }

    public TableData getSampleData(TestCase testCase, boolean authorizePII) {
        Table table = (Table)Entity.getEntity(MessageParser.EntityLink.parse(testCase.getEntityLink()), "owner", Include.ALL);
        TableData sampleData = JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(testCase.getId(), FAILED_ROWS_SAMPLE_EXTENSION), TableData.class);
        if (sampleData == null) {
            throw new EntityNotFoundException(CatalogExceptionMessage.entityNotFound(FAILED_ROWS_SAMPLE_EXTENSION, testCase.getId()));
        }
        if (!authorizePII) {
            Entity.populateEntityFieldTags("table", table.getColumns(), table.getFullyQualifiedName(), true);
            List<TagLabel> tags = this.daoCollection.tagUsageDAO().getTags(table.getFullyQualifiedName());
            table.setTags(tags);
            return PIIMasker.maskSampleData(testCase.getFailedRowsSample(), table, table.getColumns());
        }
        return sampleData;
    }

    private void putUpdateTestSuite(TestSuite testSuite, List<ResultSummary> resultSummaries) {
        TestSuiteRepository testSuiteRepository = (TestSuiteRepository)Entity.getEntityRepository(TEST_SUITE_FIELD);
        testSuite.setSummary(null);
        TestSuite original = TestSuiteRepository.copyTestSuite(testSuite);
        testSuite.setTestCaseResultSummary(resultSummaries != null ? resultSummaries : testSuite.getTestCaseResultSummary());
        EntityRepository.EntityUpdater testSuiteUpdater = testSuiteRepository.getUpdater(original, testSuite, EntityRepository.Operation.PUT);
        testSuiteUpdater.update();
    }

    private void validateParameterRule(TestCaseParameter parameter, Map<String, Object> values) {
        if (parameter.getValidationRule() != null) {
            TestCaseParameterValidationRule testCaseParameterValidationRule = parameter.getValidationRule();
            String parameterFieldToValidateAgainst = testCaseParameterValidationRule.getParameterField();
            Object valueToValidateAgainst = values.get(parameterFieldToValidateAgainst);
            Object valueToValidate = values.get(parameter.getName());
            if (valueToValidateAgainst != null && valueToValidate != null) {
                this.compareValue(valueToValidate.toString(), valueToValidateAgainst.toString(), testCaseParameterValidationRule.getRule());
            }
        }
    }

    private void compareValue(String valueToValidate, String valueToValidateAgainst, TestCaseParameterValidationRuleType validationRule) {
        Double valueToValidateDouble = this.parseStringToDouble(valueToValidate);
        Double valueToValidateAgainstDouble = this.parseStringToDouble(valueToValidateAgainst);
        if (valueToValidateDouble != null && valueToValidateAgainstDouble != null) {
            this.compareAndValidateParameterRule(validationRule, valueToValidateDouble, valueToValidateAgainstDouble);
        } else {
            LOG.warn("One of the 2 values to compare is not a number. Cannot compare values {} and {}. Skipping parameter validation", (Object)valueToValidate, (Object)valueToValidateAgainst);
        }
    }

    private Double parseStringToDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            LOG.warn("Failed to parse value {} to double", (Object)value, (Object)e);
            return null;
        }
    }

    private void compareAndValidateParameterRule(TestCaseParameterValidationRuleType validationRule, Double valueToValidate, Double valueToValidateAgainst) {
        String message = "Value %s %s %s";
        switch (validationRule) {
            case GREATER_THAN_OR_EQUALS: {
                if (!(valueToValidate < valueToValidateAgainst)) break;
                throw new IllegalArgumentException(String.format(message, valueToValidate, " is not greater than ", valueToValidateAgainst));
            }
            case LESS_THAN_OR_EQUALS: {
                if (!(valueToValidate > valueToValidateAgainst)) break;
                throw new IllegalArgumentException(String.format(message, valueToValidate, " is not less than ", valueToValidateAgainst));
            }
            case EQUALS: {
                if (!(Math.abs(valueToValidate - valueToValidateAgainst) > 1.0E-4)) break;
                throw new IllegalArgumentException(String.format(message, valueToValidate, " is not equal to ", valueToValidateAgainst));
            }
            case NOT_EQUALS: {
                if (!(Math.abs(valueToValidate - valueToValidateAgainst) < 1.0E-4)) break;
                throw new IllegalArgumentException(String.format(message, valueToValidate, " is equal to ", valueToValidateAgainst));
            }
        }
    }

    public class TestUpdater
    extends EntityRepository.EntityUpdater {
        public TestUpdater(TestCase original, TestCase updated, EntityRepository.Operation operation) {
            super((EntityRepository)TestCaseRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            MessageParser.EntityLink origEntityLink = MessageParser.EntityLink.parse(((TestCase)this.original).getEntityLink());
            EntityReference origTableRef = EntityUtil.validateEntityLink(origEntityLink);
            MessageParser.EntityLink updatedEntityLink = MessageParser.EntityLink.parse(((TestCase)this.updated).getEntityLink());
            EntityReference updatedTableRef = EntityUtil.validateEntityLink(updatedEntityLink);
            this.updateFromRelationship("entity", updatedTableRef.getType(), origTableRef, updatedTableRef, Relationship.CONTAINS, "testCase", ((TestCase)this.updated).getId());
            this.updateFromRelationship(TestCaseRepository.TEST_SUITE_FIELD, TestCaseRepository.TEST_SUITE_FIELD, ((TestCase)this.original).getTestSuite(), ((TestCase)this.updated).getTestSuite(), Relationship.HAS, "testCase", ((TestCase)this.updated).getId());
            this.updateFromRelationship("testDefinition", "testDefinition", ((TestCase)this.original).getTestDefinition(), ((TestCase)this.updated).getTestDefinition(), Relationship.CONTAINS, "testCase", ((TestCase)this.updated).getId());
            this.recordChange("parameterValues", ((TestCase)this.original).getParameterValues(), ((TestCase)this.updated).getParameterValues());
            this.recordChange("inspectionQuery", ((TestCase)this.original).getInspectionQuery(), ((TestCase)this.updated).getInspectionQuery());
            this.recordChange("computePassedFailedRowCount", ((TestCase)this.original).getComputePassedFailedRowCount(), ((TestCase)this.updated).getComputePassedFailedRowCount());
            this.recordChange(TestCaseRepository.TEST_CASE_RESULT_FIELD, ((TestCase)this.original).getTestCaseResult(), ((TestCase)this.updated).getTestCaseResult());
        }
    }

    public static class TestCaseFailureResolutionTaskWorkflow
    extends FeedRepository.TaskWorkflow {
        final TestCaseResolutionStatusRepository testCaseResolutionStatusRepository = (TestCaseResolutionStatusRepository)Entity.getEntityTimeSeriesRepository("testCaseResolutionStatus");
        final CollectionDAO.DataQualityDataTimeSeriesDAO dataQualityDataTimeSeriesDao = Entity.getCollectionDAO().dataQualityDataTimeSeriesDao();

        TestCaseFailureResolutionTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
        }

        @Transaction
        public TestCase performTask(String userName, ResolveTask resolveTask) {
            TestCaseResolutionStatus latestTestCaseResolutionStatus = (TestCaseResolutionStatus)this.testCaseResolutionStatusRepository.getLatestRecord(resolveTask.getTestCaseFQN());
            if (latestTestCaseResolutionStatus == null) {
                throw new EntityNotFoundException(String.format("Failed to find test case resolution status for %s", resolveTask.getTestCaseFQN()));
            }
            User user = (User)Entity.getEntityByName("user", userName, "", Include.ALL);
            TestCaseResolutionStatus testCaseResolutionStatus = new TestCaseResolutionStatus().withId(UUID.randomUUID()).withStateId(latestTestCaseResolutionStatus.getStateId()).withTimestamp(Long.valueOf(System.currentTimeMillis())).withTestCaseResolutionStatusType(TestCaseResolutionStatusTypes.Resolved).withTestCaseResolutionStatusDetails((Object)new Resolved().withTestCaseFailureComment(resolveTask.getNewValue()).withTestCaseFailureReason(resolveTask.getTestCaseFailureReason()).withResolvedBy(user.getEntityReference())).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withTestCaseReference(latestTestCaseResolutionStatus.getTestCaseReference()).withUpdatedBy(user.getEntityReference());
            EntityReference testCaseReference = testCaseResolutionStatus.getTestCaseReference();
            testCaseResolutionStatus.setTestCaseReference(null);
            Entity.getCollectionDAO().testCaseResolutionStatusTimeSeriesDao().insert(testCaseReference.getFullyQualifiedName(), "testCaseResolutionStatus", JsonUtils.pojoToJson(testCaseResolutionStatus));
            testCaseResolutionStatus.setTestCaseReference(testCaseReference);
            this.testCaseResolutionStatusRepository.storeRelationship(testCaseResolutionStatus);
            this.testCaseResolutionStatusRepository.postCreate(testCaseResolutionStatus);
            TestCase testCaseEntity = (TestCase)Entity.getEntity(testCaseResolutionStatus.getTestCaseReference(), "", Include.ALL);
            return testCaseEntity.withIncidentId(latestTestCaseResolutionStatus.getStateId());
        }

        @Override
        @Transaction
        public void closeTask(String userName, CloseTask closeTask) {
            TestCaseResolutionStatus latestTestCaseResolutionStatus = (TestCaseResolutionStatus)this.testCaseResolutionStatusRepository.getLatestRecord(closeTask.getTestCaseFQN());
            if (latestTestCaseResolutionStatus == null) {
                return;
            }
            if (latestTestCaseResolutionStatus.getTestCaseResolutionStatusType().equals((Object)TestCaseResolutionStatusTypes.Resolved)) {
                return;
            }
            User user = (User)Entity.getEntityByName("user", userName, "", Include.ALL);
            TestCaseResolutionStatus testCaseResolutionStatus = new TestCaseResolutionStatus().withId(UUID.randomUUID()).withStateId(latestTestCaseResolutionStatus.getStateId()).withTimestamp(Long.valueOf(System.currentTimeMillis())).withTestCaseResolutionStatusType(TestCaseResolutionStatusTypes.Resolved).withTestCaseResolutionStatusDetails((Object)new Resolved().withTestCaseFailureComment(closeTask.getComment()).withTestCaseFailureReason(TestCaseFailureReasonType.FalsePositive).withResolvedBy(user.getEntityReference())).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withTestCaseReference(latestTestCaseResolutionStatus.getTestCaseReference()).withUpdatedBy(user.getEntityReference());
            EntityReference testCaseReference = testCaseResolutionStatus.getTestCaseReference();
            testCaseResolutionStatus.setTestCaseReference(null);
            Entity.getCollectionDAO().testCaseResolutionStatusTimeSeriesDao().insert(testCaseReference.getFullyQualifiedName(), "testCaseResolutionStatus", JsonUtils.pojoToJson(testCaseResolutionStatus));
            testCaseResolutionStatus.setTestCaseReference(testCaseReference);
            this.testCaseResolutionStatusRepository.storeRelationship(testCaseResolutionStatus);
            this.testCaseResolutionStatusRepository.postCreate(testCaseResolutionStatus);
        }
    }
}

