/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record ClassificationIndex(Classification classification) implements SearchIndex
{
    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.classification.getName()).weight(10).build());
        suggest.add(SearchSuggest.builder().input(this.classification.getFullyQualifiedName()).weight(5).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.classification;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> esDoc) {
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.classification, "classification");
        esDoc.putAll(commonAttributes);
        return esDoc;
    }
}

