/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.SearchService;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record SearchServiceIndex(SearchService searchService) implements SearchIndex
{
    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.searchService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.searchService.getFullyQualifiedName()).weight(5).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.searchService;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.searchService, "searchService");
        doc.putAll(commonAttributes);
        return doc;
    }
}

