/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.List;
import org.openmetadata.schema.security.ssl.ValidateSSLClientConfig;
import org.openmetadata.schema.services.connections.database.PostgresConnection;
import org.openmetadata.schema.services.connections.database.common.AzureConfig;
import org.openmetadata.schema.services.connections.database.common.IamAuthConfig;
import org.openmetadata.schema.services.connections.database.common.basicAuth;
import org.openmetadata.service.secrets.converter.ClassConverter;
import org.openmetadata.service.util.JsonUtils;

public class PostgresConnectionClassConverter
extends ClassConverter {
    private static final List<Class<?>> SSL_SOURCE_CLASS = List.of(ValidateSSLClientConfig.class);
    private static final List<Class<?>> CONFIG_SOURCE_CLASSES = List.of(basicAuth.class, IamAuthConfig.class, AzureConfig.class);

    public PostgresConnectionClassConverter() {
        super(PostgresConnection.class);
    }

    @Override
    public Object convert(Object object) {
        PostgresConnection postgresConnection = (PostgresConnection)JsonUtils.convertValue(object, this.clazz);
        this.tryToConvert(postgresConnection.getAuthType(), CONFIG_SOURCE_CLASSES).ifPresent(arg_0 -> ((PostgresConnection)postgresConnection).setAuthType(arg_0));
        this.tryToConvert(postgresConnection.getSslConfig(), SSL_SOURCE_CLASS).ifPresent(obj -> postgresConnection.setSslConfig((Object)((ValidateSSLClientConfig)obj)));
        return postgresConnection;
    }
}

