/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.nimbusds.openid.connect.sdk.validators.BadJWTExceptions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.BadRequestException;
import net.minidev.json.JSONObject;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.ServiceTokenType;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.security.client.OidcClientConfig;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.auth.JwtResponse;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.UserUtil;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpUtils;
import org.pac4j.oidc.client.AzureAd2Client;
import org.pac4j.oidc.client.GoogleOidcClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.AzureAd2OidcConfiguration;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.config.PrivateKeyJWTClientAuthnMethodConfig;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationCodeFlowHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationCodeFlowHandler.class);
    private static final Collection<ClientAuthenticationMethod> SUPPORTED_METHODS = Arrays.asList(ClientAuthenticationMethod.CLIENT_SECRET_POST, ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.PRIVATE_KEY_JWT, ClientAuthenticationMethod.NONE);
    public static final String DEFAULT_PRINCIPAL_DOMAIN = "openmetadata.org";
    public static final String OIDC_CREDENTIAL_PROFILE = "oidcCredentialProfile";
    private final OidcClient client;
    private final List<String> claimsOrder;
    private final Map<String, String> claimsMapping;
    private final String serverUrl;
    private final ClientAuthentication clientAuthentication;
    private final String principalDomain;
    private final int tokenValidity;

    public AuthenticationCodeFlowHandler(AuthenticationConfiguration authenticationConfiguration, AuthorizerConfiguration authorizerConfiguration) {
        CommonHelper.assertNotNull((String)"OidcConfiguration", (Object)authenticationConfiguration.getOidcConfiguration());
        CommonHelper.assertNotBlank((String)"CallbackUrl", (String)authenticationConfiguration.getOidcConfiguration().getCallbackUrl());
        CommonHelper.assertNotBlank((String)"ServerUrl", (String)authenticationConfiguration.getOidcConfiguration().getServerUrl());
        this.client = this.buildOidcClient(authenticationConfiguration.getOidcConfiguration());
        this.client.setCallbackUrl(authenticationConfiguration.getOidcConfiguration().getCallbackUrl());
        this.clientAuthentication = this.getClientAuthentication(this.client.getConfiguration());
        this.serverUrl = authenticationConfiguration.getOidcConfiguration().getServerUrl();
        this.claimsOrder = authenticationConfiguration.getJwtPrincipalClaims();
        this.claimsMapping = CommonUtil.listOrEmpty((List)authenticationConfiguration.getJwtPrincipalClaimsMapping()).stream().map(s -> s.split(":")).collect(Collectors.toMap(s -> s[0], s -> s[1]));
        AuthenticationCodeFlowHandler.validatePrincipalClaimsMapping(this.claimsMapping);
        this.principalDomain = authorizerConfiguration.getPrincipalDomain();
        this.tokenValidity = authenticationConfiguration.getOidcConfiguration().getTokenValidity();
    }

    private OidcClient buildOidcClient(OidcClientConfig clientConfig) {
        String id = clientConfig.getId();
        String secret = clientConfig.getSecret();
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            GoogleOidcClient oidcClient;
            String type;
            String clientAuthenticationMethod;
            String maxClockSkew;
            String jwsAlgo;
            String useNonce;
            String discoveryUri;
            String scope;
            String responseType;
            OidcConfiguration configuration = new OidcConfiguration();
            configuration.setClientId(id);
            configuration.setResponseMode("query");
            if (CommonHelper.isNotBlank((String)secret)) {
                configuration.setSecret(secret);
            }
            if (CommonHelper.isNotBlank((String)(responseType = clientConfig.getResponseType()))) {
                configuration.setResponseType(responseType);
            }
            if (CommonHelper.isNotBlank((String)(scope = clientConfig.getScope()))) {
                configuration.setScope(scope);
            }
            if (CommonHelper.isNotBlank((String)(discoveryUri = clientConfig.getDiscoveryUri()))) {
                configuration.setDiscoveryURI(discoveryUri);
            }
            if (CommonHelper.isNotBlank((String)(useNonce = clientConfig.getUseNonce()))) {
                configuration.setUseNonce(Boolean.parseBoolean(useNonce));
            }
            if (CommonHelper.isNotBlank((String)(jwsAlgo = clientConfig.getPreferredJwsAlgorithm()))) {
                configuration.setPreferredJwsAlgorithm(JWSAlgorithm.parse((String)jwsAlgo));
            }
            if (CommonHelper.isNotBlank((String)(maxClockSkew = clientConfig.getMaxClockSkew()))) {
                configuration.setMaxClockSkew(Integer.parseInt(maxClockSkew));
            }
            if (CommonHelper.isNotBlank((String)(clientAuthenticationMethod = clientConfig.getClientAuthenticationMethod().value()))) {
                configuration.setClientAuthenticationMethod(ClientAuthenticationMethod.parse((String)clientAuthenticationMethod));
            }
            configuration.setDisablePkce(clientConfig.getDisablePkce().booleanValue());
            if (clientConfig.getCustomParams() != null) {
                for (int j = 1; j <= 5; ++j) {
                    if (!clientConfig.getCustomParams().containsKey(String.format("customParamKey%d", j))) continue;
                    configuration.addCustomParam((String)clientConfig.getCustomParams().get(String.format("customParamKey%d", j)), (String)clientConfig.getCustomParams().get(String.format("customParamValue%d", j)));
                }
            }
            if ("azure".equalsIgnoreCase(type = clientConfig.getType())) {
                AzureAd2OidcConfiguration azureAdConfiguration = new AzureAd2OidcConfiguration(configuration);
                String tenant = clientConfig.getTenant();
                if (CommonHelper.isNotBlank((String)tenant)) {
                    azureAdConfiguration.setTenant(tenant);
                }
                oidcClient = new AzureAd2Client(azureAdConfiguration);
            } else if ("google".equalsIgnoreCase(type)) {
                oidcClient = new GoogleOidcClient(configuration);
                oidcClient.getConfiguration().getCustomParams().put("access_type", "offline");
            } else {
                oidcClient = new OidcClient(configuration);
            }
            oidcClient.setName(String.format("OMOidcClient%s", oidcClient.getName()));
            return oidcClient;
        }
        throw new IllegalArgumentException("Client ID and Client Secret is required to create OidcClient");
    }

    public void handleLogin(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOG.debug("Performing Auth Login For User Session: {} ", (Object)req.getSession().getId());
            Optional<OidcCredentials> credentials = this.getUserCredentialsFromSession(req);
            if (credentials.isPresent()) {
                LOG.debug("Auth Tokens Located from Session: {} ", (Object)req.getSession().getId());
                this.sendRedirectWithToken(resp, credentials.get());
            } else {
                LOG.debug("Performing Auth Code Flow to Idp: {} ", (Object)req.getSession().getId());
                Map<String, String> params = this.buildLoginParams();
                params.put("redirect_uri", this.client.getCallbackUrl());
                this.addStateAndNonceParameters(this.client, req, params);
                if (this.client instanceof GoogleOidcClient) {
                    params.put("prompt", "consent");
                } else {
                    params.put("prompt", "login");
                }
                params.put("max_age", "0");
                String location = this.buildLoginAuthenticationRequestUrl(params);
                LOG.debug("Authentication request url: {}", (Object)location);
                resp.sendRedirect(location);
            }
        }
        catch (Exception e) {
            AuthenticationCodeFlowHandler.getErrorMessage(resp, (Exception)new TechnicalException((Throwable)e));
        }
    }

    public void handleCallback(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOG.debug("Performing Auth Callback For User Session: {} ", (Object)req.getSession().getId());
            String computedCallbackUrl = this.client.getCallbackUrl();
            Map<String, List<String>> parameters = this.retrieveCallbackParameters(req);
            AuthenticationResponse response = AuthenticationResponseParser.parse((URI)new URI(computedCallbackUrl), parameters);
            if (response instanceof AuthenticationErrorResponse) {
                AuthenticationErrorResponse authenticationErrorResponse = (AuthenticationErrorResponse)response;
                LOG.error("Bad authentication response, error={}", (Object)authenticationErrorResponse.getErrorObject());
                throw new TechnicalException("Bad authentication response");
            }
            LOG.debug("Authentication response successful");
            AuthenticationSuccessResponse successResponse = (AuthenticationSuccessResponse)response;
            OIDCProviderMetadata metadata = this.client.getConfiguration().getProviderMetadata();
            if (metadata.supportsAuthorizationResponseIssuerParam() && !metadata.getIssuer().equals((Object)successResponse.getIssuer())) {
                throw new TechnicalException("Issuer mismatch, possible mix-up attack.");
            }
            this.validateStateIfRequired(req, resp, successResponse);
            OidcCredentials credentials = this.buildCredentials(successResponse);
            this.validateAndSendTokenRequest(req, credentials, computedCallbackUrl);
            if (credentials.getRefreshToken() == null) {
                LOG.error("Refresh token is null for user session: {}", (Object)req.getSession().getId());
            }
            this.validateNonceIfRequired(req, credentials.getIdToken().getJWTClaimsSet());
            req.getSession().setAttribute(OIDC_CREDENTIAL_PROFILE, (Object)credentials);
            this.sendRedirectWithToken(resp, credentials);
        }
        catch (Exception e) {
            AuthenticationCodeFlowHandler.getErrorMessage(resp, e);
        }
    }

    public void handleLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            LOG.debug("Performing application logout");
            HttpSession session = httpServletRequest.getSession(false);
            if (session != null) {
                LOG.debug("Invalidating the session for logout");
                session.invalidate();
                httpServletResponse.sendRedirect(this.serverUrl);
            } else {
                LOG.error("No session store available for this web context");
            }
        }
        catch (Exception ex) {
            LOG.error("[Auth Logout] Error while performing logout", (Throwable)ex);
        }
    }

    public void handleRefresh(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            LOG.debug("Performing Auth Refresh For User Session: {} ", (Object)httpServletRequest.getSession().getId());
            Optional<OidcCredentials> credentials = this.getUserCredentialsFromSession(httpServletRequest);
            if (credentials.isPresent()) {
                LOG.debug("Credentials Found For User Session: {} ", (Object)httpServletRequest.getSession().getId());
                JwtResponse jwtResponse = new JwtResponse();
                jwtResponse.setAccessToken(credentials.get().getIdToken().getParsedString());
                jwtResponse.setExpiryDuration(credentials.get().getIdToken().getJWTClaimsSet().getExpirationTime().toInstant().getEpochSecond());
                this.writeJsonResponse(httpServletResponse, JsonUtils.pojoToJson(jwtResponse));
            } else {
                LOG.debug("Credentials Not Found For User Session: {}, Redirect to Logout ", (Object)httpServletRequest.getSession().getId());
                httpServletResponse.sendRedirect(String.format("%s/logout", this.serverUrl));
            }
        }
        catch (Exception e) {
            AuthenticationCodeFlowHandler.getErrorMessage(httpServletResponse, (Exception)new TechnicalException((Throwable)e));
        }
    }

    private String buildLoginAuthenticationRequestUrl(Map<String, String> params) {
        String queryString;
        try {
            queryString = AuthenticationRequest.parse(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonList((String)e.getValue())))).toQueryString();
        }
        catch (Exception e2) {
            throw new TechnicalException((Throwable)e2);
        }
        return this.client.getConfiguration().getProviderMetadata().getAuthorizationEndpointURI().toString() + "?" + queryString;
    }

    private Map<String, String> buildLoginParams() {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("scope", this.client.getConfiguration().getScope());
        authParams.put("response_type", this.client.getConfiguration().getResponseType());
        authParams.put("response_mode", "query");
        authParams.putAll(this.client.getConfiguration().getCustomParams());
        authParams.put("client_id", this.client.getConfiguration().getClientId());
        return new HashMap<String, String>(authParams);
    }

    private Optional<OidcCredentials> getUserCredentialsFromSession(HttpServletRequest request) throws URISyntaxException {
        OidcCredentials credentials = (OidcCredentials)request.getSession().getAttribute(OIDC_CREDENTIAL_PROFILE);
        if (credentials != null && credentials.getRefreshToken() != null) {
            LOG.trace("Credentials found in session: {}", (Object)credentials);
            this.renewOidcCredentials(request, credentials);
            return Optional.of(credentials);
        }
        if (credentials == null) {
            LOG.error("No credentials found against session. ID: {}", (Object)request.getSession().getId());
        } else {
            LOG.error("No refresh token found against session. ID: {}", (Object)request.getSession().getId());
        }
        return Optional.empty();
    }

    private void validateAndSendTokenRequest(HttpServletRequest req, OidcCredentials oidcCredentials, String computedCallbackUrl) throws IOException, com.nimbusds.oauth2.sdk.ParseException, URISyntaxException {
        if (oidcCredentials.getCode() != null) {
            LOG.debug("Initiating Token Request for User Session: {} ", (Object)req.getSession().getId());
            CodeVerifier verifier = (CodeVerifier)req.getSession().getAttribute(this.client.getCodeVerifierSessionAttributeName());
            TokenRequest request = this.createTokenRequest((AuthorizationGrant)new AuthorizationCodeGrant(oidcCredentials.getCode(), new URI(computedCallbackUrl), verifier));
            this.executeAuthorizationCodeTokenRequest(request, oidcCredentials);
        }
    }

    private void validateStateIfRequired(HttpServletRequest req, HttpServletResponse resp, AuthenticationSuccessResponse successResponse) {
        if (this.client.getConfiguration().isWithState()) {
            State requestState = (State)req.getSession().getAttribute(this.client.getStateSessionAttributeName());
            if (requestState == null || CommonHelper.isBlank((String)requestState.getValue())) {
                AuthenticationCodeFlowHandler.getErrorMessage(resp, (Exception)new TechnicalException("Missing state parameter"));
                return;
            }
            State responseState = successResponse.getState();
            if (responseState == null) {
                throw new TechnicalException("Missing state parameter");
            }
            LOG.debug("Request state: {}/response state: {}", (Object)requestState, (Object)responseState);
            if (!requestState.equals((Object)responseState)) {
                throw new TechnicalException("State parameter is different from the one sent in authentication request.");
            }
        }
    }

    private OidcCredentials buildCredentials(AuthenticationSuccessResponse successResponse) {
        AccessToken accessToken;
        JWT idToken;
        OidcCredentials credentials = new OidcCredentials();
        AuthorizationCode code = successResponse.getAuthorizationCode();
        if (code != null) {
            credentials.setCode(code);
        }
        if ((idToken = successResponse.getIDToken()) != null) {
            credentials.setIdToken(idToken);
        }
        if ((accessToken = successResponse.getAccessToken()) != null) {
            credentials.setAccessToken(accessToken);
        }
        return credentials;
    }

    private void validateNonceIfRequired(HttpServletRequest req, JWTClaimsSet claimsSet) throws BadJOSEException {
        if (this.client.getConfiguration().isUseNonce()) {
            String expectedNonce = (String)req.getSession().getAttribute(this.client.getNonceSessionAttributeName());
            if (CommonHelper.isNotBlank((String)expectedNonce)) {
                String tokenNonce;
                try {
                    tokenNonce = claimsSet.getStringClaim("nonce");
                }
                catch (ParseException var10) {
                    throw new BadJWTException("Invalid JWT nonce (nonce) claim: " + var10.getMessage());
                }
                if (tokenNonce == null) {
                    throw BadJWTExceptions.MISSING_NONCE_CLAIM_EXCEPTION;
                }
                if (!expectedNonce.equals(tokenNonce)) {
                    throw new BadJWTException("Unexpected JWT nonce (nonce) claim: " + tokenNonce);
                }
            } else {
                throw new TechnicalException("Missing nonce parameter from Session.");
            }
        }
    }

    protected Map<String, List<String>> retrieveCallbackParameters(HttpServletRequest request) {
        Map requestParameters = request.getParameterMap();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : requestParameters.entrySet()) {
            map.put((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
        }
        return map;
    }

    private void writeJsonResponse(HttpServletResponse response, String message) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getOutputStream().print(message);
        response.getOutputStream().flush();
        response.setStatus(200);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClientAuthentication getClientAuthentication(OidcConfiguration configuration) {
        ClientAuthenticationMethod chosenMethod;
        ClientID clientID = new ClientID(configuration.getClientId());
        ClientSecretPost clientAuthenticationMechanism = null;
        if (configuration.getSecret() == null) return clientAuthenticationMechanism;
        List metadataMethods = configuration.findProviderMetadata().getTokenEndpointAuthMethods();
        ClientAuthenticationMethod preferredMethod = AuthenticationCodeFlowHandler.getPreferredAuthenticationMethod(configuration);
        if (CommonHelper.isNotEmpty((Collection)metadataMethods)) {
            if (preferredMethod != null) {
                if (!metadataMethods.contains(preferredMethod)) throw new TechnicalException("Preferred authentication method (" + preferredMethod + ") not supported by provider according to provider metadata (" + metadataMethods + ").");
                chosenMethod = preferredMethod;
            } else {
                chosenMethod = this.firstSupportedMethod(metadataMethods);
            }
        } else {
            chosenMethod = preferredMethod != null ? preferredMethod : ClientAuthenticationMethod.getDefault();
            LOG.info("Provider metadata does not provide Token endpoint authentication methods. Using: {}", (Object)chosenMethod);
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)chosenMethod)) {
            Secret clientSecret = new Secret(configuration.getSecret());
            return new ClientSecretPost(clientID, clientSecret);
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)chosenMethod)) {
            Secret clientSecret = new Secret(configuration.getSecret());
            return new ClientSecretBasic(clientID, clientSecret);
        }
        if (!ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)chosenMethod)) return clientAuthenticationMechanism;
        PrivateKeyJWTClientAuthnMethodConfig privateKetJwtConfig = configuration.getPrivateKeyJWTClientAuthnMethodConfig();
        CommonHelper.assertNotNull((String)"privateKetJwtConfig", (Object)privateKetJwtConfig);
        JWSAlgorithm jwsAlgo = privateKetJwtConfig.getJwsAlgorithm();
        CommonHelper.assertNotNull((String)"privateKetJwtConfig.getJwsAlgorithm()", (Object)jwsAlgo);
        PrivateKey privateKey = privateKetJwtConfig.getPrivateKey();
        CommonHelper.assertNotNull((String)"privateKetJwtConfig.getPrivateKey()", (Object)privateKey);
        String keyID = privateKetJwtConfig.getKeyID();
        try {
            return new PrivateKeyJWT(clientID, configuration.findProviderMetadata().getTokenEndpointURI(), jwsAlgo, privateKey, keyID, null);
        }
        catch (JOSEException e) {
            throw new TechnicalException("Cannot instantiate private key JWT client authentication method", (Throwable)e);
        }
    }

    private static ClientAuthenticationMethod getPreferredAuthenticationMethod(OidcConfiguration config) {
        ClientAuthenticationMethod configurationMethod = config.getClientAuthenticationMethod();
        if (configurationMethod == null) {
            return null;
        }
        if (!SUPPORTED_METHODS.contains(configurationMethod)) {
            throw new TechnicalException("Configured authentication method (" + configurationMethod + ") is not supported.");
        }
        return configurationMethod;
    }

    private ClientAuthenticationMethod firstSupportedMethod(List<ClientAuthenticationMethod> metadataMethods) {
        Optional<ClientAuthenticationMethod> firstSupported = metadataMethods.stream().filter(SUPPORTED_METHODS::contains).findFirst();
        if (firstSupported.isPresent()) {
            return firstSupported.get();
        }
        throw new TechnicalException("None of the Token endpoint provider metadata authentication methods are supported: " + metadataMethods);
    }

    public static void getErrorMessage(HttpServletResponse resp, Exception e) {
        resp.setContentType("text/html; charset=UTF-8");
        LOG.error("[Auth Callback Servlet] Failed in Auth Login : {}", (Object)e.getMessage());
        resp.getOutputStream().println(String.format("<p> [Auth Callback Servlet] Failed in Auth Login : %s </p>", e.getMessage()));
    }

    private void sendRedirectWithToken(HttpServletResponse response, OidcCredentials credentials) throws ParseException, IOException {
        JWT jwt = credentials.getIdToken();
        TreeMap claims = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        claims.putAll(jwt.getJWTClaimsSet().getClaims());
        String userName = AuthenticationCodeFlowHandler.findUserNameFromClaims(this.claimsMapping, this.claimsOrder, claims);
        String email = SecurityUtil.findEmailFromClaims(this.claimsMapping, this.claimsOrder, claims, this.principalDomain);
        String url = String.format("%s/auth/callback?id_token=%s&email=%s&name=%s", this.serverUrl, credentials.getIdToken().getParsedString(), email, userName);
        response.sendRedirect(url);
    }

    private void renewOidcCredentials(HttpServletRequest request, OidcCredentials credentials) {
        LOG.debug("Renewing Credentials for User Session {}", (Object)request.getSession().getId());
        OidcConfiguration oidcConfiguration = this.client.getConfiguration();
        if (oidcConfiguration instanceof AzureAd2OidcConfiguration) {
            AzureAd2OidcConfiguration azureAd2OidcConfiguration = (AzureAd2OidcConfiguration)oidcConfiguration;
            this.refreshAccessTokenAzureAd2Token(azureAd2OidcConfiguration, credentials);
        } else {
            this.refreshTokenRequest(request, credentials);
        }
        request.getSession().setAttribute(OIDC_CREDENTIAL_PROFILE, (Object)credentials);
    }

    public void refreshTokenRequest(HttpServletRequest httpServletRequest, OidcCredentials credentials) {
        RefreshToken refreshToken = credentials.getRefreshToken();
        if (refreshToken != null) {
            try {
                TokenRequest request = this.createTokenRequest((AuthorizationGrant)new RefreshTokenGrant(refreshToken));
                HTTPResponse httpResponse = this.executeTokenHttpRequest(request);
                if (httpResponse.getStatusCode() == 200) {
                    String idTokenKey;
                    JSONObject jsonObjectResponse = httpResponse.getContentAsJSONObject();
                    if (jsonObjectResponse.containsKey((Object)(idTokenKey = "id_token"))) {
                        Object value = jsonObjectResponse.get((Object)idTokenKey);
                        if (value == null) {
                            throw new com.nimbusds.oauth2.sdk.ParseException("JSON object member with key " + idTokenKey + " has null value");
                        }
                        LOG.info("Found a JWT token in the response, trying to parse it");
                        OIDCTokenResponse tokenSuccessResponse = this.parseTokenResponseFromHttpResponse(httpResponse);
                        this.populateCredentialsFromTokenResponse(tokenSuccessResponse, credentials);
                    } else {
                        String accessToken = JSONObjectUtils.getString((JSONObject)jsonObjectResponse, (String)"access_token");
                        LOG.info("Found an access token in the response, trying to parse it, Value : {}", (Object)accessToken);
                        OIDCTokenResponse tokenSuccessResponse = this.parseTokenResponseFromHttpResponse(httpResponse);
                        this.populateCredentialsFromTokenResponse(tokenSuccessResponse, credentials);
                        OidcCredentials storedCredentials = (OidcCredentials)httpServletRequest.getSession().getAttribute(OIDC_CREDENTIAL_PROFILE);
                        TreeMap claims = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                        claims.putAll(storedCredentials.getIdToken().getJWTClaimsSet().getClaims());
                        String username = SecurityUtil.findUserNameFromClaims(this.claimsMapping, this.claimsOrder, claims);
                        User user = (User)Entity.getEntityByName("user", username, "id", Include.NON_DELETED);
                        JWTAuthMechanism jwtAuthMechanism = JWTTokenGenerator.getInstance().generateJWTToken(username, UserUtil.getRoleListFromUser(user), !CommonUtil.nullOrEmpty((Object)user.getIsAdmin()) && user.getIsAdmin() != false, user.getEmail(), this.tokenValidity, false, ServiceTokenType.OM_USER);
                        credentials.setIdToken((JWT)SignedJWT.parse((String)jwtAuthMechanism.getJWTToken()));
                    }
                    return;
                }
                throw new TechnicalException(String.format("Failed to refresh id_token, response code:%s , Error : %s", httpResponse.getStatusCode(), httpResponse.getContent()));
            }
            catch (com.nimbusds.oauth2.sdk.ParseException | IOException e) {
                throw new TechnicalException(e);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        throw new BadRequestException("No refresh token available");
    }

    public static boolean isJWT(String token) {
        return token.split("\\.").length == 3;
    }

    private void refreshAccessTokenAzureAd2Token(AzureAd2OidcConfiguration azureConfig, OidcCredentials azureAdProfile) {
        HttpURLConnection connection = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            headers.put("Accept", "application/json");
            URL tokenEndpointURL = azureConfig.findProviderMetadata().getTokenEndpointURI().toURL();
            connection = HttpUtils.openPostConnection((URL)tokenEndpointURL, headers);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
            out.write(azureConfig.makeOauth2TokenRequest(azureAdProfile.getRefreshToken().getValue()));
            out.close();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new TechnicalException("request for access token failed: " + HttpUtils.buildHttpErrorMessage((HttpURLConnection)connection));
            }
            String body = HttpUtils.readBody((HttpURLConnection)connection);
            Map<String, Object> res = JsonUtils.readValue(body, new TypeReference<Map<String, Object>>(){});
            azureAdProfile.setAccessToken((AccessToken)new BearerAccessToken((String)res.get("access_token")));
        }
        catch (IOException e) {
            try {
                throw new TechnicalException((Throwable)e);
            }
            catch (Throwable throwable) {
                HttpUtils.closeConnection(connection);
                throw throwable;
            }
        }
        HttpUtils.closeConnection((HttpURLConnection)connection);
    }

    public static String findUserNameFromClaims(Map<String, String> jwtPrincipalClaimsMapping, List<String> jwtPrincipalClaimsOrder, Map<String, ?> claims) {
        if (!CommonUtil.nullOrEmpty(jwtPrincipalClaimsMapping)) {
            String usernameClaim = jwtPrincipalClaimsMapping.get("username");
            String userNameClaimValue = SecurityUtil.getClaimOrObject(claims.get(usernameClaim));
            if (!CommonUtil.nullOrEmpty((String)userNameClaimValue)) {
                return userNameClaimValue;
            }
            throw new AuthenticationException("Invalid JWT token, 'username' claim is not present");
        }
        String jwtClaim = SecurityUtil.getFirstMatchJwtClaim(jwtPrincipalClaimsOrder, claims);
        String userName = jwtClaim.contains("@") ? jwtClaim.split("@")[0] : jwtClaim;
        return userName;
    }

    public static void validatePrincipalClaimsMapping(Map<String, String> mapping) {
        if (!CommonUtil.nullOrEmpty(mapping)) {
            String username = mapping.get("username");
            String email = mapping.get("email");
            if (CommonUtil.nullOrEmpty((String)username) || CommonUtil.nullOrEmpty((String)email)) {
                throw new IllegalArgumentException("Invalid JWT Principal Claims Mapping. Both username and email should be present");
            }
        }
    }

    private HTTPResponse executeTokenHttpRequest(TokenRequest request) throws IOException {
        HTTPRequest tokenHttpRequest = request.toHTTPRequest();
        this.client.getConfiguration().configureHttpRequest(tokenHttpRequest);
        HTTPResponse httpResponse = tokenHttpRequest.send();
        LOG.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
        return httpResponse;
    }

    private TokenRequest createTokenRequest(AuthorizationGrant grant) {
        if (this.clientAuthentication != null) {
            return new TokenRequest(this.client.getConfiguration().findProviderMetadata().getTokenEndpointURI(), this.clientAuthentication, grant);
        }
        return new TokenRequest(this.client.getConfiguration().findProviderMetadata().getTokenEndpointURI(), new ClientID(this.client.getConfiguration().getClientId()), grant);
    }

    private void addStateAndNonceParameters(OidcClient client, HttpServletRequest request, Map<String, String> params) {
        CodeChallengeMethod pkceMethod;
        if (client.getConfiguration().isWithState()) {
            State state = new State(CommonHelper.randomString((int)10));
            params.put("state", state.getValue());
            request.getSession().setAttribute(client.getStateSessionAttributeName(), (Object)state);
        }
        if (client.getConfiguration().isUseNonce()) {
            Nonce nonce = new Nonce();
            params.put("nonce", nonce.getValue());
            request.getSession().setAttribute(client.getNonceSessionAttributeName(), (Object)nonce.getValue());
        }
        if ((pkceMethod = client.getConfiguration().findPkceMethod()) == null && !client.getConfiguration().isDisablePkce()) {
            pkceMethod = CodeChallengeMethod.S256;
        }
        if (pkceMethod != null) {
            CodeVerifier verfifier = new CodeVerifier(CommonHelper.randomString((int)43));
            request.getSession().setAttribute(client.getCodeVerifierSessionAttributeName(), (Object)verfifier);
            params.put("code_challenge", CodeChallenge.compute((CodeChallengeMethod)pkceMethod, (CodeVerifier)verfifier).getValue());
            params.put("code_challenge_method", pkceMethod.getValue());
        }
    }

    private void executeAuthorizationCodeTokenRequest(TokenRequest request, OidcCredentials credentials) throws IOException, com.nimbusds.oauth2.sdk.ParseException {
        HTTPResponse httpResponse = this.executeTokenHttpRequest(request);
        OIDCTokenResponse tokenSuccessResponse = this.parseTokenResponseFromHttpResponse(httpResponse);
        this.populateCredentialsFromTokenResponse(tokenSuccessResponse, credentials);
    }

    private void populateCredentialsFromTokenResponse(OIDCTokenResponse tokenSuccessResponse, OidcCredentials credentials) {
        OIDCTokens oidcTokens = tokenSuccessResponse.getOIDCTokens();
        credentials.setAccessToken(oidcTokens.getAccessToken());
        credentials.setRefreshToken(oidcTokens.getRefreshToken());
        if (oidcTokens.getIDToken() != null) {
            credentials.setIdToken(oidcTokens.getIDToken());
        }
    }

    private OIDCTokenResponse parseTokenResponseFromHttpResponse(HTTPResponse httpResponse) throws com.nimbusds.oauth2.sdk.ParseException {
        TokenResponse response = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
        if (response instanceof TokenErrorResponse) {
            TokenErrorResponse tokenErrorResponse = (TokenErrorResponse)response;
            ErrorObject errorObject = tokenErrorResponse.getErrorObject();
            throw new TechnicalException("Bad token response, error=" + errorObject.getCode() + ", description=" + errorObject.getDescription());
        }
        LOG.debug("Token response successful");
        return (OIDCTokenResponse)response;
    }
}

