/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import java.util.HashSet;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.CatalogPrincipal;
import org.openmetadata.service.security.auth.CatalogSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=100)
public class CatalogOpenIdAuthorizationRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogOpenIdAuthorizationRequestFilter.class);
    public static final String X_AUTH_PARAMS_EMAIL_HEADER = "X-Auth-Params-Email";
    private static final String HEALTH_END_POINT = "health";

    private CatalogOpenIdAuthorizationRequestFilter() {
    }

    public CatalogOpenIdAuthorizationRequestFilter(AuthenticationConfiguration config, AuthorizerConfiguration conf) {
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        if (this.isHealthEndpoint(containerRequestContext)) {
            LOG.debug("Caller is health-agent, no authorization needed.");
            return;
        }
        MultivaluedMap headers = containerRequestContext.getHeaders();
        String email = this.extractAuthorizedEmail((MultivaluedMap<String, String>)headers);
        String principal = this.extractAuthorizedUserName(email);
        LOG.debug("AuthorizedUserName:{}", (Object)principal);
        CatalogPrincipal catalogPrincipal = new CatalogPrincipal(principal, email);
        String scheme = containerRequestContext.getUriInfo().getRequestUri().getScheme();
        CatalogSecurityContext catalogSecurityContext = new CatalogSecurityContext(catalogPrincipal, scheme, "openid", new HashSet<String>());
        LOG.debug("SecurityContext {}", (Object)catalogSecurityContext);
        containerRequestContext.setSecurityContext((SecurityContext)catalogSecurityContext);
    }

    protected boolean isHealthEndpoint(ContainerRequestContext containerRequestContext) {
        UriInfo uriInfo = containerRequestContext.getUriInfo();
        return uriInfo.getPath().equalsIgnoreCase(HEALTH_END_POINT);
    }

    protected String extractAuthorizedUserName(String openIdEmail) {
        String[] openIdEmailParts = openIdEmail.split("@");
        return openIdEmailParts[0];
    }

    protected String extractAuthorizedEmail(MultivaluedMap<String, String> headers) {
        LOG.debug("Request Headers:{}", headers);
        String openIdEmail = (String)headers.getFirst((Object)X_AUTH_PARAMS_EMAIL_HEADER);
        if (CommonUtil.nullOrEmpty((String)openIdEmail)) {
            throw new AuthenticationException("Not authorized; User's Email is not present");
        }
        return openIdEmail;
    }
}

