/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.socket;

import io.socket.engineio.server.EngineIoServer;
import io.socket.engineio.server.EngineIoServerOptions;
import io.socket.socketio.server.SocketIoNamespace;
import io.socket.socketio.server.SocketIoServer;
import io.socket.socketio.server.SocketIoSocket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketManager {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketManager.class);
    private static WebSocketManager instance;
    private final EngineIoServer engineIoServer;
    private final SocketIoServer socketIoServer;
    public static final String FEED_BROADCAST_CHANNEL = "activityFeed";
    public static final String TASK_BROADCAST_CHANNEL = "taskChannel";
    public static final String JOB_STATUS_BROADCAST_CHANNEL = "jobStatus";
    public static final String MENTION_CHANNEL = "mentionChannel";
    public static final String ANNOUNCEMENT_CHANNEL = "announcementChannel";
    private final Map<UUID, Map<String, SocketIoSocket>> activityFeedEndpoints = new ConcurrentHashMap<UUID, Map<String, SocketIoSocket>>();

    private WebSocketManager(EngineIoServerOptions eiOptions) {
        this.engineIoServer = new EngineIoServer(eiOptions);
        this.socketIoServer = new SocketIoServer(this.engineIoServer);
        this.initializeHandlers();
    }

    private void initializeHandlers() {
        SocketIoNamespace ns = this.socketIoServer.namespace("/");
        ns.on("connection", args -> {
            String userId;
            SocketIoSocket socket = (SocketIoSocket)args[0];
            List remoteAddress = (List)socket.getInitialHeaders().get("RemoteAddress");
            Map initialHeaders = socket.getInitialHeaders();
            List userIdHeaders = CommonUtil.listOrEmpty((List)((List)initialHeaders.get("UserId")));
            String string = userId = userIdHeaders.isEmpty() ? (String)socket.getInitialQuery().get("userId") : (String)userIdHeaders.get(0);
            if (userId != null && !userId.equals("")) {
                LOG.info("Client : {} with Remote Address:{} connected {} ", new Object[]{userId, remoteAddress, initialHeaders});
                socket.on("disconnect", args1 -> {
                    LOG.info("Client from: {} with Remote Address:{} disconnected.", (Object)userId, (Object)remoteAddress);
                    UUID id = UUID.fromString(userId);
                    Map<String, SocketIoSocket> allUserConnection = this.activityFeedEndpoints.get(id);
                    allUserConnection.remove(socket.getId());
                    this.activityFeedEndpoints.put(id, allUserConnection);
                });
                socket.on("connect_error", args1 -> LOG.error("Connection ERROR for user:{} with Remote Address:{} disconnected", (Object)userId, (Object)remoteAddress));
                socket.on("connect_failed", args1 -> LOG.error("Connection failed ERROR for user: {} with Remote Address: {} disconnected", (Object)userId, (Object)remoteAddress));
                UUID id = UUID.fromString(userId);
                HashMap<String, SocketIoSocket> userSocketConnections = this.activityFeedEndpoints.containsKey(id) ? this.activityFeedEndpoints.get(id) : new HashMap<String, SocketIoSocket>();
                userSocketConnections.put(socket.getId(), socket);
                this.activityFeedEndpoints.put(id, userSocketConnections);
            }
        });
        ns.on("error", args -> LOG.error("Connection error on the server"));
    }

    public static WebSocketManager getInstance() {
        return instance;
    }

    public void broadCastMessageToAll(String event, String message) {
        this.activityFeedEndpoints.forEach((key, value) -> value.forEach((key1, value1) -> value1.send(event, new Object[]{message})));
    }

    public void sendToOne(UUID receiver, String event, String message) {
        if (this.activityFeedEndpoints.containsKey(receiver)) {
            this.activityFeedEndpoints.get(receiver).forEach((key, value) -> value.send(event, new Object[]{message}));
        }
    }

    public void sendToOne(String username, String event, String message) {
        try {
            UUID receiver = Entity.getEntityReferenceByName("user", username, Include.NON_DELETED).getId();
            if (this.activityFeedEndpoints.containsKey(receiver)) {
                this.activityFeedEndpoints.get(receiver).forEach((key, value) -> value.send(event, new Object[]{message}));
            }
        }
        catch (EntityNotFoundException ex) {
            LOG.error("User with {} not found", (Object)username);
        }
    }

    public void sendToManyWithUUID(Set<UUID> receivers, String event, String message) {
        receivers.forEach(e -> this.sendToOne((UUID)e, event, message));
    }

    public void sendToManyWithString(List<CollectionDAO.EntityRelationshipRecord> receivers, String event, String message) {
        receivers.forEach(e -> this.sendToOne(e.getId(), event, message));
    }

    public EngineIoServer getEngineIoServer() {
        return this.engineIoServer;
    }

    public SocketIoServer getSocketIoServer() {
        return this.socketIoServer;
    }

    public Map<UUID, Map<String, SocketIoSocket>> getActivityFeedEndpoints() {
        return this.activityFeedEndpoints;
    }

    public static class WebSocketManagerBuilder {
        private WebSocketManagerBuilder() {
        }

        public static void build(EngineIoServerOptions eiOptions) {
            instance = new WebSocketManager(eiOptions);
        }
    }
}

