/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps;

import java.util.List;
import org.openmetadata.schema.AppRuntime;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.services.ingestionPipelines.CreateIngestionPipeline;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppRunRecord;
import org.openmetadata.schema.entity.app.AppType;
import org.openmetadata.schema.entity.app.ScheduleTimeline;
import org.openmetadata.schema.entity.app.ScheduleType;
import org.openmetadata.schema.entity.app.ScheduledExecutionContext;
import org.openmetadata.schema.entity.applications.configuration.ApplicationConfig;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.ingestionPipelines.AirflowConfig;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.metadataIngestion.ApplicationPipeline;
import org.openmetadata.schema.metadataIngestion.SourceConfig;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.AppException;
import org.openmetadata.service.apps.ApplicationHandler;
import org.openmetadata.service.apps.NativeApplication;
import org.openmetadata.service.apps.scheduler.AppScheduler;
import org.openmetadata.service.apps.scheduler.OmAppJobListener;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.MetadataServiceRepository;
import org.openmetadata.service.resources.apps.AppResource;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractNativeApplication
implements NativeApplication {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNativeApplication.class);
    protected CollectionDAO collectionDAO;
    private App app;
    protected SearchRepository searchRepository;
    private static final String SERVICE_NAME = "OpenMetadata";

    public AbstractNativeApplication(CollectionDAO collectionDAO, SearchRepository searchRepository) {
        this.collectionDAO = collectionDAO;
        this.searchRepository = searchRepository;
    }

    @Override
    public void init(App app) {
        this.app = app;
    }

    @Override
    public void install() {
        if (Boolean.TRUE.equals(this.app.getDeleted()) || this.app.getAppSchedule() != null && this.app.getAppSchedule().getScheduleTimeline().equals((Object)ScheduleTimeline.NONE)) {
            return;
        }
        if (this.app.getAppType().equals((Object)AppType.Internal) && AppResource.SCHEDULED_TYPES.contains(this.app.getScheduleType())) {
            try {
                ApplicationHandler.getInstance().removeOldJobs(this.app);
                ApplicationHandler.getInstance().migrateQuartzConfig(this.app);
                ApplicationHandler.getInstance().fixCorruptedInstallation(this.app);
            }
            catch (SchedulerException e) {
                throw AppException.byMessage("ApplicationHandler", "SchedulerError", "Error while migrating application configuration: " + this.app.getName());
            }
            this.scheduleInternal();
        } else if (this.app.getAppType() == AppType.External && AppResource.SCHEDULED_TYPES.contains(this.app.getScheduleType())) {
            this.scheduleExternal();
        }
    }

    @Override
    public void triggerOnDemand() {
        if (!this.app.getScheduleType().equals((Object)ScheduleType.ScheduledOrManual)) {
            throw new IllegalArgumentException("App does not support manual trigger.");
        }
        AppRuntime runtime = AbstractNativeApplication.getAppRuntime(this.app);
        this.validateServerExecutableApp(runtime);
        AppScheduler.getInstance().triggerOnDemandApplication(this.app);
    }

    public void scheduleInternal() {
        AppRuntime runtime = (AppRuntime)JsonUtils.convertValue(this.app.getRuntime(), ScheduledExecutionContext.class);
        this.validateServerExecutableApp(runtime);
        AppScheduler.getInstance().addApplicationSchedule(this.app);
    }

    public void scheduleExternal() {
        IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
        try {
            this.bindExistingIngestionToApplication(ingestionPipelineRepository);
            this.updateAppConfig(ingestionPipelineRepository, this.getApp().getAppConfiguration());
        }
        catch (EntityNotFoundException ex) {
            ApplicationConfig config = JsonUtils.convertValue(this.getApp().getAppConfiguration(), ApplicationConfig.class);
            this.createAndBindIngestionPipeline(ingestionPipelineRepository, config);
        }
    }

    private void bindExistingIngestionToApplication(IngestionPipelineRepository ingestionPipelineRepository) {
        String fqn = FullyQualifiedName.add(SERVICE_NAME, this.getApp().getName());
        IngestionPipeline storedPipeline = (IngestionPipeline)ingestionPipelineRepository.getByName(null, fqn, ingestionPipelineRepository.getFields("id"));
        List<CollectionDAO.EntityRelationshipRecord> records = this.collectionDAO.relationshipDAO().findTo(this.getApp().getId(), "app", Relationship.HAS.ordinal(), "ingestionPipeline");
        if (records.isEmpty()) {
            this.collectionDAO.relationshipDAO().insert(this.getApp().getId(), storedPipeline.getId(), "app", "ingestionPipeline", Relationship.HAS.ordinal());
        }
    }

    private void updateAppConfig(IngestionPipelineRepository repository, Object appConfiguration) {
        String fqn = FullyQualifiedName.add(SERVICE_NAME, this.getApp().getName());
        IngestionPipeline updated = (IngestionPipeline)repository.findByName(fqn, Include.NON_DELETED);
        ApplicationPipeline appPipeline = JsonUtils.convertValue(updated.getSourceConfig().getConfig(), ApplicationPipeline.class);
        IngestionPipeline original = JsonUtils.deepCopy(updated, IngestionPipeline.class);
        updated.setSourceConfig(updated.getSourceConfig().withConfig((Object)appPipeline.withAppConfig(appConfiguration)));
        repository.update(null, original, updated);
    }

    private void createAndBindIngestionPipeline(IngestionPipelineRepository ingestionPipelineRepository, ApplicationConfig config) {
        MetadataServiceRepository serviceEntityRepository = (MetadataServiceRepository)Entity.getEntityRepository("metadataService");
        EntityReference service = ((MetadataService)serviceEntityRepository.getByName(null, SERVICE_NAME, serviceEntityRepository.getFields("id"))).getEntityReference();
        CreateIngestionPipeline createPipelineRequest = new CreateIngestionPipeline().withName(this.getApp().getName()).withDisplayName(this.getApp().getDisplayName()).withDescription(this.getApp().getDescription()).withPipelineType(PipelineType.APPLICATION).withSourceConfig(new SourceConfig().withConfig((Object)new ApplicationPipeline().withSourcePythonClass(this.getApp().getSourcePythonClass()).withAppConfig((Object)config).withAppPrivateConfig(this.getApp().getPrivateConfiguration()))).withAirflowConfig(new AirflowConfig().withScheduleInterval(this.getApp().getAppSchedule().getCronExpression())).withService(service);
        IngestionPipeline ingestionPipeline = this.getIngestionPipeline(createPipelineRequest, String.format("%sBot", this.getApp().getName()), "admin").withProvider(ProviderType.USER);
        ingestionPipelineRepository.setFullyQualifiedName(ingestionPipeline);
        ingestionPipelineRepository.initializeEntity(ingestionPipeline);
        this.collectionDAO.relationshipDAO().insert(this.getApp().getId(), ingestionPipeline.getId(), "app", "ingestionPipeline", Relationship.HAS.ordinal());
    }

    @Override
    public void cleanup() {
    }

    protected void validateServerExecutableApp(AppRuntime context) {
        if (!this.app.getAppType().equals((Object)AppType.Internal)) {
            throw new IllegalArgumentException("Application cannot be executed internally in Server. Please check if the App supports internal Server Execution.");
        }
        if (context == null || !Boolean.TRUE.equals(context.getEnabled())) {
            throw new IllegalArgumentException("Applications does not support on demand execution or the context is not Internal.");
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) {
        String appName = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"appName");
        App jobApp = (App)this.collectionDAO.applicationDAO().findEntityByName(appName);
        ApplicationHandler.getInstance().setAppRuntimeProperties(jobApp);
        this.init(jobApp);
        this.startApp(jobExecutionContext);
    }

    @Override
    public void configure() {
    }

    @Override
    public void raisePreviewMessage(App app) {
        throw AppException.byMessage(app.getName(), "Preview", "App is in Preview Mode. Enable it from the server configuration.");
    }

    public static AppRuntime getAppRuntime(App app) {
        return (AppRuntime)JsonUtils.convertValue(app.getRuntime(), ScheduledExecutionContext.class);
    }

    protected IngestionPipeline getIngestionPipeline(CreateIngestionPipeline create, String botName, String user) {
        IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
        OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(ingestionPipelineRepository.getOpenMetadataApplicationConfig(), botName).build();
        return ingestionPipelineRepository.copy(new IngestionPipeline(), (CreateEntity)create, user).withPipelineType(create.getPipelineType()).withAirflowConfig(create.getAirflowConfig()).withOpenMetadataServerConnection(openMetadataServerConnection).withSourceConfig(create.getSourceConfig()).withLoggerLevel(create.getLoggerLevel()).withService(create.getService());
    }

    private OmAppJobListener getJobListener(JobExecutionContext jobExecutionContext) throws SchedulerException {
        return (OmAppJobListener)jobExecutionContext.getScheduler().getListenerManager().getJobListener("OM_JOB_LISTENER");
    }

    protected AppRunRecord getJobRecord(JobExecutionContext jobExecutionContext) {
        OmAppJobListener listener = this.getJobListener(jobExecutionContext);
        return listener.getAppRunRecordForJob(jobExecutionContext);
    }

    protected void pushAppStatusUpdates(JobExecutionContext jobExecutionContext, AppRunRecord appRecord, boolean update) {
        OmAppJobListener listener = this.getJobListener(jobExecutionContext);
        listener.pushApplicationStatusUpdates(jobExecutionContext, appRecord, update);
    }

    public CollectionDAO getCollectionDAO() {
        return this.collectionDAO;
    }

    public App getApp() {
        return this.app;
    }

    public SearchRepository getSearchRepository() {
        return this.searchRepository;
    }
}

