/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public class AppUtil {

    public static class AppRunHistory {
        private String appId;
        private String appName;
        private String runId;
        private Long timestamp;
        private AppRunStatus status;
        private String runType;

        public String getAppId() {
            return this.appId;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getRunId() {
            return this.runId;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public AppRunStatus getStatus() {
            return this.status;
        }

        public String getRunType() {
            return this.runType;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setRunId(String runId) {
            this.runId = runId;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public void setStatus(AppRunStatus status) {
            this.status = status;
        }

        public void setRunType(String runType) {
            this.runType = runType;
        }
    }

    public static enum AppRunStatus {
        STARTED("started"),
        RUNNING("running"),
        FAILED("failed"),
        ABORTED("aborted");

        private final String value;
        private static final Map<String, AppRunStatus> CONSTANTS;

        private AppRunStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AppRunStatus fromValue(String value) {
            AppRunStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AppRunStatus>();
            for (AppRunStatus c : AppRunStatus.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum RunType {
        ON_DEMAND_RUN("OnDemandRun"),
        SCHEDULED_RUN("ScheduledRun");

        private final String value;
        private static final Map<String, RunType> CONSTANTS;

        private RunType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RunType fromValue(String value) {
            RunType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, RunType>();
            for (RunType c : RunType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

