/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.configuration.apps.AppPrivateConfig;
import org.openmetadata.schema.api.configuration.apps.AppsPrivateConfiguration;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.apps.AppException;
import org.openmetadata.service.apps.scheduler.AppScheduler;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.AppRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationHandler.class);
    private static ApplicationHandler instance;
    private final OpenMetadataApplicationConfig config;
    private final AppsPrivateConfiguration privateConfiguration;
    private final AppRepository appRepository;

    private ApplicationHandler(OpenMetadataApplicationConfig config) {
        this.config = config;
        this.privateConfiguration = config.getAppsPrivateConfiguration();
        this.appRepository = new AppRepository();
    }

    public static void initialize(OpenMetadataApplicationConfig config) {
        if (instance != null) {
            return;
        }
        instance = new ApplicationHandler(config);
    }

    public void setAppRuntimeProperties(App app) {
        app.setOpenMetadataServerConnection(new OpenMetadataConnectionBuilder(this.config, app.getBot().getName()).build());
        if (this.privateConfiguration != null && !CommonUtil.nullOrEmpty((List)this.privateConfiguration.getAppsPrivateConfiguration())) {
            for (AppPrivateConfig appPrivateConfig : this.privateConfiguration.getAppsPrivateConfiguration()) {
                if (!app.getName().equals(appPrivateConfig.getName())) continue;
                app.setPreview(appPrivateConfig.getPreview());
                app.setPrivateConfiguration((Object)appPrivateConfig.getParameters());
            }
        }
    }

    public Boolean isPreview(String appName) {
        if (this.privateConfiguration != null && !CommonUtil.nullOrEmpty((List)this.privateConfiguration.getAppsPrivateConfiguration())) {
            for (AppPrivateConfig appPrivateConfig : this.privateConfiguration.getAppsPrivateConfiguration()) {
                if (!appName.equals(appPrivateConfig.getName())) continue;
                return appPrivateConfig.getPreview();
            }
        }
        return false;
    }

    public void triggerApplicationOnDemand(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        this.runMethodFromApplication(app, daoCollection, searchRepository, "triggerOnDemand");
    }

    public void installApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        this.runMethodFromApplication(app, daoCollection, searchRepository, "install");
    }

    public void configureApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        this.runMethodFromApplication(app, daoCollection, searchRepository, "configure");
    }

    public void performCleanup(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        this.runMethodFromApplication(app, daoCollection, searchRepository, "cleanup");
    }

    public Object runAppInit(App app, CollectionDAO daoCollection, SearchRepository searchRepository) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this.setAppRuntimeProperties(app);
        Class<?> clz = Class.forName(app.getClassName());
        Object resource = clz.getDeclaredConstructor(CollectionDAO.class, SearchRepository.class).newInstance(daoCollection, searchRepository);
        if (Boolean.TRUE.equals(app.getPreview())) {
            Method preview = resource.getClass().getMethod("raisePreviewMessage", App.class);
            preview.invoke(resource, app);
        }
        Method initMethod = resource.getClass().getMethod("init", App.class);
        initMethod.invoke(resource, app);
        return resource;
    }

    public void runMethodFromApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository, String methodName) {
        try {
            Object resource = this.runAppInit(app, daoCollection, searchRepository);
            Method scheduleMethod = resource.getClass().getMethod(methodName, new Class[0]);
            scheduleMethod.invoke(resource, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            LOG.error("Exception encountered", (Throwable)e);
            throw new UnhandledServerException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UnhandledServerException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw AppException.byMessage(app.getName(), methodName, e.getTargetException().getMessage());
        }
    }

    public void migrateQuartzConfig(App application) throws SchedulerException {
        JobDetail jobDetails = AppScheduler.getInstance().getScheduler().getJobDetail(new JobKey(application.getName(), "OMAppsJobGroup"));
        if (jobDetails == null) {
            return;
        }
        JobDataMap jobDataMap = jobDetails.getJobDataMap();
        if (jobDataMap == null) {
            return;
        }
        String appInfo = jobDataMap.getString("applicationInfoKey");
        if (appInfo == null) {
            return;
        }
        LOG.info("migrating app quartz configuration for {}", (Object)application.getName());
        App updatedApp = JsonUtils.readOrConvertValue(appInfo, App.class);
        App currentApp = (App)this.appRepository.getDao().findEntityById(application.getId());
        updatedApp.setOpenMetadataServerConnection(null);
        updatedApp.setPrivateConfiguration(null);
        updatedApp.setScheduleType(currentApp.getScheduleType());
        updatedApp.setAppSchedule(currentApp.getAppSchedule());
        updatedApp.setUpdatedBy(currentApp.getUpdatedBy());
        updatedApp.setFullyQualifiedName(currentApp.getFullyQualifiedName());
        EntityRepository.EntityUpdater updater = this.appRepository.getUpdater(currentApp, updatedApp, EntityRepository.Operation.PATCH);
        updater.update();
        AppScheduler.getInstance().deleteScheduledApplication(updatedApp);
        AppScheduler.getInstance().addApplicationSchedule(updatedApp);
        LOG.info("migrated app configuration for {}", (Object)application.getName());
    }

    public void fixCorruptedInstallation(App application) throws SchedulerException {
        JobDetail jobDetails = AppScheduler.getInstance().getScheduler().getJobDetail(new JobKey(application.getName(), "OMAppsJobGroup"));
        if (jobDetails == null) {
            return;
        }
        JobDataMap jobDataMap = jobDetails.getJobDataMap();
        if (jobDataMap == null) {
            return;
        }
        String appName = jobDataMap.getString("appName");
        if (appName == null) {
            LOG.info("corrupt entry for app {}, reinstalling", (Object)application.getName());
            App app = (App)this.appRepository.getDao().findEntityByName(application.getName());
            AppScheduler.getInstance().deleteScheduledApplication(app);
            AppScheduler.getInstance().addApplicationSchedule(app);
        }
    }

    public void removeOldJobs(App app) throws SchedulerException {
        Set jobKeys = AppScheduler.getInstance().getScheduler().getJobKeys(GroupMatcher.groupContains((String)"OMAppsJobGroup"));
        jobKeys.forEach(jobKey -> {
            try {
                Class clz = AppScheduler.getInstance().getScheduler().getJobDetail(jobKey).getJobClass();
                if (!jobKey.getName().equals(app.getName()) && clz.getName().equals(app.getClassName())) {
                    LOG.info("deleting old job {}", (Object)jobKey.getName());
                    AppScheduler.getInstance().getScheduler().deleteJob(jobKey);
                }
            }
            catch (SchedulerException e) {
                LOG.error("Error deleting job {}", (Object)jobKey.getName(), (Object)e);
            }
        });
    }

    public static ApplicationHandler getInstance() {
        return instance;
    }
}

