/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent;

import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.apps.bundles.changeEvent.email.EmailPublisher;
import org.openmetadata.service.apps.bundles.changeEvent.feed.ActivityFeedPublisher;
import org.openmetadata.service.apps.bundles.changeEvent.gchat.GChatPublisher;
import org.openmetadata.service.apps.bundles.changeEvent.generic.GenericPublisher;
import org.openmetadata.service.apps.bundles.changeEvent.msteams.MSTeamsPublisher;
import org.openmetadata.service.apps.bundles.changeEvent.slack.SlackEventPublisher;

public class AlertFactory {
    public static Destination<ChangeEvent> getAlert(EventSubscription subscription, SubscriptionDestination config) {
        return switch (config.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriptionDestination.SubscriptionType.SLACK -> new SlackEventPublisher(subscription, config);
            case SubscriptionDestination.SubscriptionType.MS_TEAMS -> new MSTeamsPublisher(subscription, config);
            case SubscriptionDestination.SubscriptionType.G_CHAT -> new GChatPublisher(subscription, config);
            case SubscriptionDestination.SubscriptionType.WEBHOOK -> new GenericPublisher(subscription, config);
            case SubscriptionDestination.SubscriptionType.EMAIL -> new EmailPublisher(subscription, config);
            case SubscriptionDestination.SubscriptionType.ACTIVITY_FEED -> new ActivityFeedPublisher(subscription, config);
        };
    }
}

