/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent.email;

import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.alert.type.EmailAlertConfig;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.apps.bundles.changeEvent.email.EmailMessage;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.formatter.decorators.EmailMessageDecorator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailPublisher
implements Destination<ChangeEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(EmailPublisher.class);
    private final MessageDecorator<EmailMessage> emailDecorator = new EmailMessageDecorator();
    private final EmailAlertConfig emailAlertConfig;
    private final CollectionDAO daoCollection;
    private final SubscriptionDestination subscriptionDestination;
    private final EventSubscription eventSubscription;

    public EmailPublisher(EventSubscription eventSubscription, SubscriptionDestination subscriptionDestination) {
        if (subscriptionDestination.getType() != SubscriptionDestination.SubscriptionType.EMAIL) {
            throw new IllegalArgumentException("Email Alert Invoked with Illegal Type and Settings.");
        }
        this.eventSubscription = eventSubscription;
        this.subscriptionDestination = subscriptionDestination;
        this.emailAlertConfig = JsonUtils.convertValue(subscriptionDestination.getConfig(), EmailAlertConfig.class);
        this.daoCollection = Entity.getCollectionDAO();
    }

    @Override
    public void sendMessage(ChangeEvent event) throws EventPublisherException {
        try {
            Set<String> receivers = SubscriptionUtil.getTargetsForAlert((SubscriptionAction)this.emailAlertConfig, this.subscriptionDestination.getCategory(), SubscriptionDestination.SubscriptionType.EMAIL, event);
            EmailMessage emailMessage = this.emailDecorator.buildOutgoingMessage(this.eventSubscription.getFullyQualifiedName(), event);
            for (String email : receivers) {
                EmailUtil.sendChangeEventMail(this.eventSubscription.getFullyQualifiedName(), email, emailMessage);
            }
            this.setSuccessStatus(System.currentTimeMillis());
        }
        catch (Exception e) {
            this.setErrorStatus(System.currentTimeMillis(), 500, e.getMessage());
            String message = CatalogExceptionMessage.eventPublisherFailedToPublish(SubscriptionDestination.SubscriptionType.EMAIL, event, e.getMessage());
            LOG.error(message);
            throw new EventPublisherException(message, (Pair<UUID, ChangeEvent>)Pair.of((Object)this.subscriptionDestination.getId(), (Object)event));
        }
    }

    @Override
    public void sendTestMessage() throws EventPublisherException {
        try {
            Set receivers = this.emailAlertConfig.getReceivers();
            EmailMessage emailMessage = this.emailDecorator.buildOutgoingTestMessage(this.eventSubscription.getFullyQualifiedName());
            for (String email : receivers) {
                EmailUtil.sendChangeEventMail(this.eventSubscription.getFullyQualifiedName(), email, emailMessage);
            }
            this.setSuccessStatus(System.currentTimeMillis());
        }
        catch (Exception e) {
            this.setErrorStatus(System.currentTimeMillis(), 500, e.getMessage());
            String message = CatalogExceptionMessage.eventPublisherFailedToPublish(SubscriptionDestination.SubscriptionType.EMAIL, e.getMessage());
            LOG.error(message);
            throw new EventPublisherException(message);
        }
    }

    @Override
    public EventSubscription getEventSubscriptionForDestination() {
        return this.eventSubscription;
    }

    @Override
    public boolean getEnabled() {
        return this.subscriptionDestination.getEnabled();
    }

    @Override
    public void close() {
        LOG.debug("Email Publisher Stopped");
    }

    @Override
    public SubscriptionDestination getSubscriptionDestination() {
        return this.subscriptionDestination;
    }
}

