/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent.msteams;

import java.util.List;
import java.util.UUID;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.apps.bundles.changeEvent.msteams.TeamsMessage;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.formatter.decorators.MSTeamsMessageDecorator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSTeamsPublisher
implements Destination<ChangeEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(MSTeamsPublisher.class);
    private final MessageDecorator<TeamsMessage> teamsMessageFormatter = new MSTeamsMessageDecorator();
    private final Webhook webhook;
    private Invocation.Builder target;
    private final Client client;
    private final SubscriptionDestination subscriptionDestination;
    private final EventSubscription eventSubscription;

    public MSTeamsPublisher(EventSubscription eventSubscription, SubscriptionDestination subscriptionDestination) {
        if (subscriptionDestination.getType() == SubscriptionDestination.SubscriptionType.MS_TEAMS) {
            String msTeamsWebhookURL;
            this.eventSubscription = eventSubscription;
            this.subscriptionDestination = subscriptionDestination;
            this.webhook = JsonUtils.convertValue(subscriptionDestination.getConfig(), Webhook.class);
            this.client = SubscriptionUtil.getClient(subscriptionDestination.getTimeout(), subscriptionDestination.getReadTimeout());
            if (this.webhook != null && this.webhook.getEndpoint() != null && !CommonUtil.nullOrEmpty((String)(msTeamsWebhookURL = this.webhook.getEndpoint().toString()))) {
                this.target = SubscriptionUtil.appendHeadersToTarget(this.client, msTeamsWebhookURL);
            }
        } else {
            throw new IllegalArgumentException("MsTeams Alert Invoked with Illegal Type and Settings.");
        }
    }

    @Override
    public void sendMessage(ChangeEvent event) throws EventPublisherException {
        try {
            TeamsMessage teamsMessage = this.teamsMessageFormatter.buildOutgoingMessage(this.eventSubscription.getFullyQualifiedName(), event);
            List<Invocation.Builder> targets = SubscriptionUtil.getTargetsForWebhookAlert((SubscriptionAction)this.webhook, this.subscriptionDestination.getCategory(), SubscriptionDestination.SubscriptionType.MS_TEAMS, this.client, event);
            if (this.target != null) {
                targets.add(this.target);
            }
            for (Invocation.Builder actionTarget : targets) {
                if (this.webhook.getSecretKey() != null && !this.webhook.getSecretKey().isEmpty()) {
                    String hmac = "sha256=" + CommonUtil.calculateHMAC((String)this.webhook.getSecretKey(), (String)JsonUtils.pojoToJson(teamsMessage));
                    SubscriptionUtil.postWebhookMessage(this, actionTarget.header("X-OM-Signature", (Object)hmac), teamsMessage);
                    continue;
                }
                SubscriptionUtil.postWebhookMessage(this, actionTarget, teamsMessage);
            }
        }
        catch (Exception e) {
            String message = CatalogExceptionMessage.eventPublisherFailedToPublish(SubscriptionDestination.SubscriptionType.MS_TEAMS, event, e.getMessage());
            LOG.error(message);
            throw new EventPublisherException(message, (Pair<UUID, ChangeEvent>)Pair.of((Object)this.subscriptionDestination.getId(), (Object)event));
        }
    }

    @Override
    public void sendTestMessage() throws EventPublisherException {
        try {
            TeamsMessage teamsMessage = this.teamsMessageFormatter.buildOutgoingTestMessage(this.eventSubscription.getFullyQualifiedName());
            if (this.target != null) {
                if (this.webhook.getSecretKey() != null && !this.webhook.getSecretKey().isEmpty()) {
                    String hmac = "sha256=" + CommonUtil.calculateHMAC((String)this.webhook.getSecretKey(), (String)JsonUtils.pojoToJson(teamsMessage));
                    SubscriptionUtil.postWebhookMessage(this, this.target.header("X-OM-Signature", (Object)hmac), teamsMessage);
                } else {
                    SubscriptionUtil.postWebhookMessage(this, this.target, teamsMessage);
                }
            }
        }
        catch (Exception e) {
            String message = CatalogExceptionMessage.eventPublisherFailedToPublish(SubscriptionDestination.SubscriptionType.MS_TEAMS, e.getMessage());
            LOG.error(message);
            throw new EventPublisherException(message);
        }
    }

    @Override
    public EventSubscription getEventSubscriptionForDestination() {
        return this.eventSubscription;
    }

    @Override
    public boolean getEnabled() {
        return this.subscriptionDestination.getEnabled();
    }

    @Override
    public void close() {
        if (null != this.client) {
            this.client.close();
        }
    }

    @Override
    public SubscriptionDestination getSubscriptionDestination() {
        return this.subscriptionDestination;
    }
}

