/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResultList;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.dataInsight.type.KpiResult;
import org.openmetadata.schema.dataInsight.type.KpiTarget;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.applications.configuration.internal.DataInsightsReportAppConfig;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.AbstractNativeApplication;
import org.openmetadata.service.apps.bundles.insights.utils.TimestampUtils;
import org.openmetadata.service.events.scheduled.template.DataInsightDescriptionAndOwnerTemplate;
import org.openmetadata.service.events.scheduled.template.DataInsightTotalAssetTemplate;
import org.openmetadata.service.exception.EventSubscriptionJobException;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DataInsightSystemChartRepository;
import org.openmetadata.service.jdbi3.KpiRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.util.SubscriptionUtil;
import org.openmetadata.service.util.Utilities;
import org.openmetadata.service.workflows.searchIndex.PaginatedEntitiesSource;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInsightsReportApp
extends AbstractNativeApplication {
    private static final Logger LOG = LoggerFactory.getLogger(DataInsightsReportApp.class);
    private static final String KPI_NOT_SET = "No Kpi Set";
    private static final String PREVIOUS_TOTAL_ASSET_COUNT = "PreviousTotalAssetCount";
    private static final String CURRENT_TOTAL_ASSET_COUNT = "CurrentTotalAssetCount";
    private final DataInsightSystemChartRepository systemChartRepository = new DataInsightSystemChartRepository();

    public DataInsightsReportApp(CollectionDAO collectionDAO, SearchRepository searchRepository) {
        super(collectionDAO, searchRepository);
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) {
        String appName = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"appName");
        App app = (App)this.collectionDAO.applicationDAO().findEntityByName(appName);
        long currentTime = System.currentTimeMillis();
        long startTime = TimestampUtils.getStartOfDayTimestamp(TimestampUtils.subtractDays(currentTime, 6));
        long endTime = TimestampUtils.getStartOfDayTimestamp(currentTime);
        TimeConfig timeConfig = new TimeConfig(startTime, endTime, TimestampUtils.timestampToString(startTime, "dd"), TimestampUtils.timestampToString(endTime, "dd"), 7);
        try {
            DataInsightsReportAppConfig insightAlertConfig = JsonUtils.convertValue(app.getAppConfiguration(), DataInsightsReportAppConfig.class);
            if (Boolean.TRUE.equals(insightAlertConfig.getSendToAdmins())) {
                this.sendToAdmins(this.searchRepository.getSearchClient(), timeConfig);
            }
            if (Boolean.TRUE.equals(insightAlertConfig.getSendToTeams())) {
                this.sendReportsToTeams(this.searchRepository.getSearchClient(), timeConfig);
            }
        }
        catch (Exception e) {
            LOG.error("[DIReport] Failed in sending report due to", (Throwable)e);
            throw new EventSubscriptionJobException(e);
        }
    }

    private void sendReportsToTeams(SearchClient searchClient, TimeConfig timeConfig) throws SearchIndexException {
        PaginatedEntitiesSource teamReader = new PaginatedEntitiesSource("team", 10, List.of("name", "email", "users"));
        while (!teamReader.isDone()) {
            Object resultList = teamReader.readNext((Map)null);
            for (Team team : ((ResultList)resultList).getData()) {
                HashSet<String> emails = new HashSet<String>();
                String email = team.getEmail();
                if (!CommonUtil.nullOrEmpty((String)email)) {
                    emails.add(email);
                } else {
                    for (EntityReference userRef : team.getUsers()) {
                        User user = (User)Entity.getEntity("user", userRef.getId(), "", Include.NON_DELETED);
                        emails.add(user.getEmail());
                    }
                }
                HashMap<String, Object> contextData = new HashMap<String, Object>();
                try {
                    DataInsightTotalAssetTemplate totalAssetTemplate = this.createTotalAssetTemplate(searchClient, team.getName(), timeConfig, contextData);
                    DataInsightDescriptionAndOwnerTemplate descriptionTemplate = this.createDescriptionTemplate(searchClient, team.getName(), timeConfig, contextData);
                    DataInsightDescriptionAndOwnerTemplate ownershipTemplate = this.createOwnershipTemplate(searchClient, team.getName(), timeConfig, contextData);
                    DataInsightDescriptionAndOwnerTemplate tierTemplate = this.createTierTemplate(searchClient, team.getName(), timeConfig, contextData);
                    EmailUtil.sendDataInsightEmailNotificationToUser(emails, Utilities.getMonthAndDateFromEpoch(timeConfig.startTime()), Utilities.getMonthAndDateFromEpoch(timeConfig.endTime()), totalAssetTemplate, descriptionTemplate, ownershipTemplate, tierTemplate, EmailUtil.getDataInsightReportSubject(), "dataInsightReport");
                }
                catch (Exception ex) {
                    LOG.error("[DataInsightReport] Failed for Team: {}, Reason : {}", (Object)team.getName(), (Object)ex.getMessage());
                }
            }
        }
    }

    private void sendToAdmins(SearchClient searchClient, TimeConfig timeConfig) {
        Set<String> emailList = SubscriptionUtil.getAdminsData(SubscriptionDestination.SubscriptionType.EMAIL);
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        try {
            DataInsightTotalAssetTemplate totalAssetTemplate = this.createTotalAssetTemplate(searchClient, null, timeConfig, contextData);
            DataInsightDescriptionAndOwnerTemplate descriptionTemplate = this.createDescriptionTemplate(searchClient, null, timeConfig, contextData);
            DataInsightDescriptionAndOwnerTemplate ownershipTemplate = this.createOwnershipTemplate(searchClient, null, timeConfig, contextData);
            DataInsightDescriptionAndOwnerTemplate tierTemplate = this.createTierTemplate(searchClient, null, timeConfig, contextData);
            EmailUtil.sendDataInsightEmailNotificationToUser(emailList, Utilities.getMonthAndDateFromEpoch(timeConfig.startTime()), Utilities.getMonthAndDateFromEpoch(timeConfig.endTime()), totalAssetTemplate, descriptionTemplate, ownershipTemplate, tierTemplate, EmailUtil.getDataInsightReportSubject(), "dataInsightReport");
        }
        catch (Exception ex) {
            LOG.error("[DataInsightReport] Failed for Admin, Reason : {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private List<Kpi> getAvailableKpi() {
        KpiRepository repository = (KpiRepository)Entity.getEntityRepository("kpi");
        return repository.listAll(repository.getFields("dataInsightChart"), new ListFilter(Include.NON_DELETED));
    }

    private KpiResult getKpiResult(String fqn) {
        KpiRepository repository = (KpiRepository)Entity.getEntityRepository("kpi");
        return repository.getKpiResult(fqn);
    }

    private DataInsightTotalAssetTemplate createTotalAssetTemplate(SearchClient searchClient, String team, TimeConfig timeConfig, Map<String, Object> contextData) throws IOException {
        LinkedHashMap<String, Integer> dateMap = new LinkedHashMap<String, Integer>();
        Utilities.getLastSevenDays(timeConfig.endTime()).forEach(day -> dateMap.put((String)day, 0));
        Map<String, Double> dateWithCount = this.getDateMapWithCountFromChart("total_data_assets", timeConfig.startTime(), timeConfig.endTime(), team);
        Double previousCount = dateWithCount.getOrDefault(timeConfig.startDay(), 0.0);
        Double currentCount = dateWithCount.getOrDefault(timeConfig.endDay(), 0.0);
        contextData.put(PREVIOUS_TOTAL_ASSET_COUNT, previousCount);
        contextData.put(CURRENT_TOTAL_ASSET_COUNT, currentCount);
        dateWithCount.forEach((key, value) -> dateMap.put((String)key, value.intValue()));
        this.processDateMapToNormalize(dateMap);
        if (previousCount == 0.0) {
            return new DataInsightTotalAssetTemplate(String.valueOf(currentCount.intValue()), 0.0, timeConfig.numberOfDaysChange(), dateMap);
        }
        return new DataInsightTotalAssetTemplate(String.valueOf(currentCount.intValue()), (currentCount - previousCount) / previousCount * 100.0, timeConfig.numberOfDaysChange(), dateMap);
    }

    private DataInsightDescriptionAndOwnerTemplate createDescriptionTemplate(SearchClient searchClient, String team, TimeConfig timeConfig, Map<String, Object> contextData) throws ParseException, IOException {
        LinkedHashMap<String, Integer> dateMap = new LinkedHashMap<String, Integer>();
        Utilities.getLastSevenDays(timeConfig.endTime()).forEach(day -> dateMap.put((String)day, 0));
        Map<String, Double> dateWithCount = this.getDateMapWithCountFromChart("number_of_data_asset_with_description_kpi", timeConfig.startTime(), timeConfig.endTime(), team);
        Double previousCompletedDescription = dateWithCount.getOrDefault(timeConfig.startDay(), 0.0);
        Double currentCompletedDescription = dateWithCount.getOrDefault(timeConfig.endDay(), 0.0);
        Double previousTotalAssetCount = (double)((Double)contextData.get(PREVIOUS_TOTAL_ASSET_COUNT));
        Double currentTotalAssetCount = (double)((Double)contextData.get(CURRENT_TOTAL_ASSET_COUNT));
        dateWithCount.forEach((key, value) -> dateMap.put((String)key, value.intValue()));
        this.processDateMapToNormalize(dateMap);
        double previousPercentCompleted = 0.0;
        if (previousTotalAssetCount != 0.0) {
            previousPercentCompleted = previousCompletedDescription / previousTotalAssetCount * 100.0;
        }
        double currentPercentCompleted = 0.0;
        if (currentTotalAssetCount != 0.0) {
            currentPercentCompleted = currentCompletedDescription / currentTotalAssetCount * 100.0;
        }
        return this.getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.DESCRIPTION, "percentage_of_data_asset_with_description_kpi", currentPercentCompleted, currentPercentCompleted - previousPercentCompleted, currentCompletedDescription.intValue(), timeConfig.numberOfDaysChange(), dateMap);
    }

    private DataInsightDescriptionAndOwnerTemplate createOwnershipTemplate(SearchClient searchClient, String team, TimeConfig timeConfig, Map<String, Object> contextData) throws IOException {
        LinkedHashMap<String, Integer> dateMap = new LinkedHashMap<String, Integer>();
        Utilities.getLastSevenDays(timeConfig.endTime()).forEach(day -> dateMap.put((String)day, 0));
        Map<String, Double> dateWithCount = this.getDateMapWithCountFromChart("number_of_data_asset_with_owner_kpi", timeConfig.startTime(), timeConfig.endTime(), team);
        Double previousHasOwner = dateWithCount.getOrDefault(timeConfig.startDay(), 0.0);
        Double currentHasOwner = dateWithCount.getOrDefault(timeConfig.endDay(), 0.0);
        Double previousTotalAssetCount = (double)((Double)contextData.get(PREVIOUS_TOTAL_ASSET_COUNT));
        Double currentTotalAssetCount = (double)((Double)contextData.get(CURRENT_TOTAL_ASSET_COUNT));
        dateWithCount.forEach((key, value) -> dateMap.put((String)key, value.intValue()));
        this.processDateMapToNormalize(dateMap);
        double previousPercentCompleted = 0.0;
        if (previousTotalAssetCount != 0.0) {
            previousPercentCompleted = previousHasOwner / previousTotalAssetCount * 100.0;
        }
        double currentPercentCompleted = 0.0;
        if (currentTotalAssetCount != 0.0) {
            currentPercentCompleted = currentHasOwner / currentTotalAssetCount * 100.0;
        }
        return this.getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.OWNER, "percentage_of_data_asset_with_owner_kpi", currentPercentCompleted, currentPercentCompleted - previousPercentCompleted, currentHasOwner.intValue(), timeConfig.numberOfDaysChange(), dateMap);
    }

    private DataInsightDescriptionAndOwnerTemplate createTierTemplate(SearchClient searchClient, String team, TimeConfig timeConfig, Map<String, Object> contextData) throws ParseException, IOException {
        LinkedHashMap<String, Integer> dateMap = new LinkedHashMap<String, Integer>();
        Utilities.getLastSevenDays(timeConfig.endTime()).forEach(day -> dateMap.put((String)day, 0));
        Map<String, Double> dateWithCount = this.getDateMapWithCountFromTierChart("total_data_assets_by_tier", timeConfig.startTime(), timeConfig.endTime(), team);
        Double previousHasTier = dateWithCount.getOrDefault(timeConfig.startDay(), 0.0);
        Double currentHasTier = dateWithCount.getOrDefault(timeConfig.endDay(), 0.0);
        Double previousTotalAssetCount = (double)((Double)contextData.get(PREVIOUS_TOTAL_ASSET_COUNT));
        Double currentTotalAssetCount = (double)((Double)contextData.get(CURRENT_TOTAL_ASSET_COUNT));
        dateWithCount.forEach((key, value) -> dateMap.put((String)key, value.intValue()));
        this.processDateMapToNormalize(dateMap);
        double previousPercentCompleted = 0.0;
        if (previousTotalAssetCount != 0.0) {
            previousPercentCompleted = previousHasTier / previousTotalAssetCount * 100.0;
        }
        double currentPercentCompleted = 0.0;
        if (currentTotalAssetCount != 0.0) {
            currentPercentCompleted = currentHasTier / currentTotalAssetCount * 100.0;
        }
        HashMap<String, Double> tierData = new HashMap<String, Double>();
        return new DataInsightDescriptionAndOwnerTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.TIER, null, String.valueOf(currentHasTier.intValue()), currentPercentCompleted, KPI_NOT_SET, currentPercentCompleted - previousPercentCompleted, false, "", timeConfig.numberOfDaysChange(), tierData, dateMap);
    }

    private Map<String, Double> getDateMapWithCountFromTierChart(String chartName, Long startTime, Long endTime, String team) throws IOException {
        String filter = this.prepareTeamFilter(team);
        Map<String, DataInsightCustomChartResultList> systemChartMap = this.systemChartRepository.listChartData(chartName, startTime, endTime, filter);
        return systemChartMap.get(chartName).getResults().stream().filter(result -> !result.getGroup().equals("NoTier")).map(result -> {
            HashMap<String, Double> dayCount = new HashMap<String, Double>();
            dayCount.put(TimestampUtils.timestampToString(result.getDay().longValue(), "dd"), result.getCount());
            return dayCount;
        }).flatMap(map -> map.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingDouble(Map.Entry::getValue)));
    }

    private Map<String, Double> getDateMapWithCountFromChart(String chartName, Long startTime, Long endTime, String team) throws IOException {
        String filter = this.prepareTeamFilter(team);
        Map<String, DataInsightCustomChartResultList> systemChartMap = this.systemChartRepository.listChartData(chartName, startTime, endTime, filter);
        return systemChartMap.get(chartName).getResults().stream().map(result -> {
            HashMap<String, Double> dayCount = new HashMap<String, Double>();
            dayCount.put(TimestampUtils.timestampToString(result.getDay().longValue(), "dd"), result.getCount());
            return dayCount;
        }).flatMap(map -> map.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingDouble(Map.Entry::getValue)));
    }

    private String prepareTeamFilter(String team) {
        String filter = null;
        if (!CommonUtil.nullOrEmpty((String)team)) {
            filter = String.format("{\"query\":{\"bool\":{\"must\":[{\"bool\":{\"should\":[{\"term\":{\"owners.displayName.keyword\":\"%s\"}}]}}]}}}", team);
        }
        return filter;
    }

    private DataInsightDescriptionAndOwnerTemplate getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType metricType, String chartKpiName, Double percentCompleted, Double percentChange, int totalAssets, int numberOfDaysChange, Map<String, Integer> dateMap) throws IOException {
        List<Kpi> kpiList = this.getAvailableKpi();
        Kpi validKpi = null;
        boolean isKpiAvailable = false;
        for (Kpi kpiObj : kpiList) {
            if (!kpiObj.getDataInsightChart().getName().equals(chartKpiName)) continue;
            validKpi = kpiObj;
            isKpiAvailable = true;
            break;
        }
        DataInsightDescriptionAndOwnerTemplate.KpiCriteria criteria = null;
        String totalDaysLeft = "";
        String targetKpi = KPI_NOT_SET;
        if (isKpiAvailable) {
            targetKpi = String.format("%.2f", validKpi.getTargetValue());
            KpiResult result = this.getKpiResult(validKpi.getName());
            if (result != null) {
                boolean isTargetMet = ((KpiTarget)result.getTargetResult().get(0)).getTargetMet();
                criteria = DataInsightDescriptionAndOwnerTemplate.KpiCriteria.IN_PROGRESS;
                if (isTargetMet) {
                    criteria = DataInsightDescriptionAndOwnerTemplate.KpiCriteria.MET;
                } else {
                    long leftDaysInMilli = validKpi.getEndDate() - System.currentTimeMillis();
                    if (leftDaysInMilli >= 0L) {
                        totalDaysLeft = String.valueOf((int)(leftDaysInMilli / 86400000L));
                    } else {
                        criteria = DataInsightDescriptionAndOwnerTemplate.KpiCriteria.NOT_MET;
                    }
                }
            }
        }
        return new DataInsightDescriptionAndOwnerTemplate(metricType, criteria, String.valueOf(totalAssets), percentCompleted, targetKpi, percentChange, isKpiAvailable, totalDaysLeft, numberOfDaysChange, null, dateMap);
    }

    private void processDateMapToNormalize(Map<String, Integer> dateMap) {
        Pair<Integer, Integer> maxIn = this.getMinAndMax(dateMap.values().stream().toList());
        dateMap.replaceAll((k, v) -> this.getNormalizedValue(v.doubleValue(), ((Integer)maxIn.getRight()).doubleValue(), ((Integer)maxIn.getLeft()).doubleValue()).intValue());
    }

    private Pair<Integer, Integer> getMinAndMax(List<Integer> integers) {
        Optional minOptional = integers.stream().min(Integer::compareTo);
        Optional maxOptional = integers.stream().max(Integer::compareTo);
        int min = (Integer)minOptional.orElseThrow(() -> new IllegalArgumentException("List is empty"));
        int max = (Integer)maxOptional.orElseThrow(() -> new IllegalArgumentException("List is empty"));
        return Pair.of((Object)min, (Object)max);
    }

    private Double getNormalizedValue(Double value, Double max, Double min) {
        if (max - min == 0.0) {
            return 0.0;
        }
        return (value - min) / (max - min) * 50.0;
    }

    private record TimeConfig(Long startTime, Long endTime, String startDay, String endDay, int numberOfDaysChange) {
    }
}

