/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateReportDataProcessor
implements Processor<List<ReportData>, List<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateReportDataProcessor.class);
    private final String name;
    private final StepStats stats = new StepStats();

    public CreateReportDataProcessor(int total, String name) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
        this.name = name;
    }

    @Override
    public List<ReportData> process(List<?> input, Map<String, Object> contextData) throws SearchIndexException {
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>();
        try {
            ReportData.ReportDataType reportDataType = (ReportData.ReportDataType)contextData.get("ReportDataType");
            Long timestamp = (Long)contextData.get("@timestamp");
            for (Object eventData : input) {
                ReportData reportData = new ReportData().withReportDataType(reportDataType).withTimestamp(timestamp).withData(eventData);
                reportDataList.add(reportData);
            }
            this.updateStats(input.size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.size())).withFailedCount(Integer.valueOf(input.size())).withSuccessCount(Integer.valueOf(0)).withMessage("Create Report Data Processor Encounter Failure.").withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[CreateReportDataProcessor] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.size());
            throw new SearchIndexException(error);
        }
        return reportDataList;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    public String getName() {
        return this.name;
    }
}

