/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.search.opensearch;

import java.io.IOException;
import org.openmetadata.service.apps.bundles.insights.search.DataInsightsSearchInterface;
import os.org.opensearch.client.Request;
import os.org.opensearch.client.Response;
import os.org.opensearch.client.ResponseException;
import os.org.opensearch.client.RestClient;

public class OpenSearchDataInsightsClient
implements DataInsightsSearchInterface {
    private final RestClient client;

    public OpenSearchDataInsightsClient(RestClient client) {
        this.client = client;
    }

    private Response performRequest(String method, String path) throws IOException {
        Request request = new Request(method, path);
        return this.client.performRequest(request);
    }

    private Response performRequest(String method, String path, String payload) throws IOException {
        Request request = new Request(method, path);
        request.setJsonEntity(payload);
        return this.client.performRequest(request);
    }

    @Override
    public void createLifecyclePolicy(String name, String policy) throws IOException {
        try {
            this.performRequest("PUT", String.format("/_plugins/_ism/policies/%s", name), policy);
        }
        catch (ResponseException ex) {
            if (ex.getResponse().getStatusLine().getStatusCode() == 409) {
                this.performRequest("DELETE", String.format("/_plugins/_ism/policies/%s", name));
                this.performRequest("PUT", String.format("/_plugins/_ism/policies/%s", name), policy);
            }
            throw ex;
        }
    }

    @Override
    public void createComponentTemplate(String name, String template) throws IOException {
        this.performRequest("PUT", String.format("/_component_template/%s", name), template);
    }

    @Override
    public void createIndexTemplate(String name, String template) throws IOException {
        this.performRequest("PUT", String.format("/_index_template/%s", name), template);
    }

    @Override
    public void createDataStream(String name) throws IOException {
        this.performRequest("PUT", String.format("/_data_stream/%s", name));
    }

    @Override
    public Boolean dataAssetDataStreamExists(String name) throws IOException {
        Response response = this.performRequest("HEAD", String.format("/%s", name));
        return response.getStatusLine().getStatusCode() == 200;
    }

    @Override
    public void createDataAssetsDataStream(String name) throws IOException {
        String resourcePath = "/dataInsights/opensearch";
        this.createLifecyclePolicy("di-data-assets-lifecycle", this.readResource(String.format("%s/indexLifecyclePolicy.json", resourcePath)));
        this.createComponentTemplate("di-data-assets-mapping", this.readResource(String.format("%s/indexMappingsTemplate.json", resourcePath)));
        this.createIndexTemplate("di-data-assets", this.readResource(String.format("%s/indexTemplate.json", resourcePath)));
        this.createDataStream(name);
    }

    @Override
    public void deleteDataAssetDataStream(String name) throws IOException {
        this.performRequest("DELETE", String.format("_data_stream/%s", name));
    }
}

