/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.sinks;

import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.ReportDataRepository;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.interfaces.Sink;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDataSink
implements Sink<List<ReportData>, Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDataSink.class);
    private final String name;
    private final StepStats stats = new StepStats();

    public ReportDataSink(int total, String name) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
        this.name = name;
    }

    @Override
    public Boolean write(List<ReportData> data, Map<String, Object> contextData) throws SearchIndexException {
        try {
            ReportData.ReportDataType reportDataType = (ReportData.ReportDataType)contextData.get("ReportDataType");
            this.createReportDataRecords(data, reportDataType);
            this.updateStats(data.size(), 0);
        }
        catch (Exception e) {
            IndexingError indexingError = new IndexingError().withErrorSource(IndexingError.ErrorSource.SINK).withSubmittedCount(Integer.valueOf(data.size())).withSuccessCount(Integer.valueOf(0)).withFailedCount(Integer.valueOf(data.size())).withMessage("Couldn't write ReportData to Database.").withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[ReportDataSink] Failed, Details: {}", (Object)JsonUtils.pojoToJson(indexingError));
            this.updateStats(0, data.size());
            throw new SearchIndexException(indexingError);
        }
        return true;
    }

    private void createReportDataRecords(List<ReportData> reportDataList, ReportData.ReportDataType reportDataType) {
        for (ReportData reportData : reportDataList) {
            ((ReportDataRepository)Entity.getEntityTimeSeriesRepository("entityReportData")).createNewRecord(reportData, "reportData.reportDataResult", reportDataType.toString());
        }
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    public String getName() {
        return this.name;
    }
}

