/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;

public class WorkflowStats {
    private final String name;
    private List<String> failures = new ArrayList<String>();
    private StepStats workflowStats = new StepStats();
    private final Map<String, StepStats> workflowStepStats = new HashMap<String, StepStats>();

    public WorkflowStats(String name) {
        this.name = name;
    }

    public void setWorkflowStatsTotalRecords(int totalRecords) {
        this.workflowStats.setTotalRecords(Integer.valueOf(totalRecords));
    }

    public void addWorkflowStatsTotalRecords(int totalRecordsToAdd) {
        this.workflowStats.setTotalRecords(Integer.valueOf(this.workflowStats.getTotalRecords() + totalRecordsToAdd));
    }

    public void addFailure(String msg) {
        this.failures.add(msg);
    }

    public Boolean hasFailed() {
        return !this.failures.isEmpty();
    }

    public void updateWorkflowStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.workflowStats, currentSuccess, currentFailed);
    }

    public void updateWorkflowStepStats(String stepName, StepStats newStepStats) {
        this.workflowStepStats.put(stepName, newStepStats);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getFailures() {
        return this.failures;
    }

    public StepStats getWorkflowStats() {
        return this.workflowStats;
    }

    public Map<String, StepStats> getWorkflowStepStats() {
        return this.workflowStepStats;
    }
}

