/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.costAnalysis.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.analytics.AggregatedCostAnalysisReportData;
import org.openmetadata.schema.analytics.DataAssetMetrics;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.apps.bundles.insights.workflows.costAnalysis.CostAnalysisWorkflow;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatedCostAnalysisReportDataAggregator
implements Processor<List<AggregatedCostAnalysisReportData>, Map<String, Map<String, Map<String, CostAnalysisWorkflow.AggregatedCostAnalysisData>>>> {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatedCostAnalysisReportDataAggregator.class);
    private final String name = "[CostAnalysisWorkflow] Aggregated Cost Anlysis Report Data Aggregator";
    private final StepStats stats = new StepStats();

    public AggregatedCostAnalysisReportDataAggregator(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public List<AggregatedCostAnalysisReportData> process(Map<String, Map<String, Map<String, CostAnalysisWorkflow.AggregatedCostAnalysisData>>> input, Map<String, Object> contextData) throws SearchIndexException {
        ArrayList<AggregatedCostAnalysisReportData> aggregatedCostAnalysisReportDataList = new ArrayList<AggregatedCostAnalysisReportData>();
        try {
            for (Map.Entry<String, Map<String, Map<String, CostAnalysisWorkflow.AggregatedCostAnalysisData>>> entry : input.entrySet()) {
                String entityType = entry.getKey();
                Map<String, Map<String, CostAnalysisWorkflow.AggregatedCostAnalysisData>> entityTypeEntryValue = entry.getValue();
                for (Map.Entry<String, Map<String, CostAnalysisWorkflow.AggregatedCostAnalysisData>> serviceTypeEntry : entityTypeEntryValue.entrySet()) {
                    String serviceType = serviceTypeEntry.getKey();
                    Map<String, CostAnalysisWorkflow.AggregatedCostAnalysisData> serviceTypeEntryValue = serviceTypeEntry.getValue();
                    for (Map.Entry<String, CostAnalysisWorkflow.AggregatedCostAnalysisData> serviceNameEntry : serviceTypeEntryValue.entrySet()) {
                        String serviceName = serviceNameEntry.getKey();
                        CostAnalysisWorkflow.AggregatedCostAnalysisData aggregatedData = serviceNameEntry.getValue();
                        DataAssetMetrics unusedDataAssets = aggregatedData.unusedDataAssets().withTotalCount(Double.valueOf((Double)aggregatedData.unusedDataAssets().getCount().getThreeDays())).withTotalSize(Double.valueOf((Double)aggregatedData.unusedDataAssets().getSize().getThreeDays()));
                        DataAssetMetrics frequentlyUsedDataAssets = aggregatedData.frequentlyUsedDataAssets().withTotalCount(Double.valueOf((Double)aggregatedData.frequentlyUsedDataAssets().getCount().getThreeDays())).withTotalSize(Double.valueOf((Double)aggregatedData.frequentlyUsedDataAssets().getSize().getThreeDays()));
                        AggregatedCostAnalysisReportData aggregatedCostAnalysisReportData = new AggregatedCostAnalysisReportData().withEntityType(entityType).withServiceType(serviceType).withServiceName(serviceName).withUnusedDataAssets(unusedDataAssets).withFrequentlyUsedDataAssets(frequentlyUsedDataAssets).withTotalCount(aggregatedData.totalCount()).withTotalSize(aggregatedData.totalSize());
                        aggregatedCostAnalysisReportDataList.add(aggregatedCostAnalysisReportData);
                    }
                }
            }
            this.updateStats(input.size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.size())).withFailedCount(Integer.valueOf(input.size())).withSuccessCount(Integer.valueOf(0)).withMessage(String.format("Aggregated Cost Analysis Aggregator Encounter Failure: %s", e.getMessage())).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[AggregatedCostAnalysisAggregator] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.size());
            throw new SearchIndexException(error);
        }
        return aggregatedCostAnalysisReportDataList;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    public String getName() {
        return this.name;
    }
}

