/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.costAnalysis.processors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.analytics.AggregatedCostAnalysisReportData;
import org.openmetadata.schema.analytics.DataAssetMetrics;
import org.openmetadata.schema.analytics.DataAssetValues;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.LifeCycle;
import org.openmetadata.service.apps.bundles.insights.utils.TimestampUtils;
import org.openmetadata.service.apps.bundles.insights.workflows.costAnalysis.CostAnalysisWorkflow;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatedCostAnalysisReportDataProcessor
implements Processor<List<AggregatedCostAnalysisReportData>, List<CostAnalysisWorkflow.CostAnalysisTableData>> {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatedCostAnalysisReportDataProcessor.class);
    private final StepStats stats = new StepStats();

    public AggregatedCostAnalysisReportDataProcessor(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public List<AggregatedCostAnalysisReportData> process(List<CostAnalysisWorkflow.CostAnalysisTableData> input, Map<String, Object> contextData) throws SearchIndexException {
        ArrayList<AggregatedCostAnalysisReportData> aggregatedCostAnalysisReportDataList = new ArrayList<AggregatedCostAnalysisReportData>();
        Long timestamp = (Long)contextData.get("@timestamp");
        Map aggregatedCostAnalysisDataMap = (Map)contextData.get("aggregatedCostAnalysisDataMap");
        try {
            for (CostAnalysisWorkflow.CostAnalysisTableData tableData : input) {
                String entityType = "table";
                String serviceType = tableData.table().getServiceType().toString();
                String serviceName = tableData.table().getService().getName();
                if (!aggregatedCostAnalysisDataMap.containsKey(entityType)) {
                    aggregatedCostAnalysisDataMap.put(entityType, new HashMap());
                }
                if (!((Map)aggregatedCostAnalysisDataMap.get(entityType)).containsKey(serviceType)) {
                    ((Map)aggregatedCostAnalysisDataMap.get(entityType)).put(serviceType, new HashMap());
                }
                if (!((Map)((Map)aggregatedCostAnalysisDataMap.get(entityType)).get(serviceType)).containsKey(serviceName)) {
                    ((Map)((Map)aggregatedCostAnalysisDataMap.get(entityType)).get(serviceType)).put(serviceName, new CostAnalysisWorkflow.AggregatedCostAnalysisData(0.0, 0.0, new DataAssetMetrics().withCount(new DataAssetValues().withThreeDays((Object)0.0).withSevenDays((Object)0.0).withFourteenDays((Object)0.0).withThirtyDays((Object)0.0).withSixtyDays((Object)0.0)).withSize(new DataAssetValues().withThreeDays((Object)0.0).withSevenDays((Object)0.0).withFourteenDays((Object)0.0).withThirtyDays((Object)0.0).withSixtyDays((Object)0.0)).withTotalCount(Double.valueOf(0.0)).withTotalSize(Double.valueOf(0.0)), new DataAssetMetrics().withCount(new DataAssetValues().withThreeDays((Object)0.0).withSevenDays((Object)0.0).withFourteenDays((Object)0.0).withThirtyDays((Object)0.0).withSixtyDays((Object)0.0)).withSize(new DataAssetValues().withThreeDays((Object)0.0).withSevenDays((Object)0.0).withFourteenDays((Object)0.0).withThirtyDays((Object)0.0).withSixtyDays((Object)0.0)).withTotalCount(Double.valueOf(0.0)).withTotalSize(Double.valueOf(0.0))));
                }
                CostAnalysisWorkflow.AggregatedCostAnalysisData aggregatedCostAnalysisData = (CostAnalysisWorkflow.AggregatedCostAnalysisData)((Map)((Map)aggregatedCostAnalysisDataMap.get(entityType)).get(serviceType)).get(serviceName);
                Double tableSize = 0.0;
                if (tableData.oSize().isPresent()) {
                    tableSize = tableData.oSize().get();
                }
                DataAssetMetrics unusedDataAssets = aggregatedCostAnalysisData.unusedDataAssets();
                DataAssetMetrics frequentlyUsedDataAssets = aggregatedCostAnalysisData.frequentlyUsedDataAssets();
                if (tableData.oLifeCycle().isPresent()) {
                    LifeCycle lifeCycle = tableData.oLifeCycle().get();
                    Long periodTimestamp = TimestampUtils.getEndOfDayTimestamp(TimestampUtils.subtractDays(timestamp, 3));
                    if (lifeCycle.getAccessed().getTimestamp() <= periodTimestamp) {
                        unusedDataAssets.withCount(unusedDataAssets.getCount().withThreeDays((Object)((Double)unusedDataAssets.getCount().getThreeDays() + 1.0)));
                        unusedDataAssets.withSize(unusedDataAssets.getSize().withThreeDays((Object)((Double)unusedDataAssets.getSize().getThreeDays() + tableSize)));
                    } else {
                        frequentlyUsedDataAssets.withCount(frequentlyUsedDataAssets.getCount().withThreeDays((Object)((Double)frequentlyUsedDataAssets.getCount().getThreeDays() + 1.0)));
                        frequentlyUsedDataAssets.withSize(frequentlyUsedDataAssets.getSize().withThreeDays((Object)((Double)frequentlyUsedDataAssets.getSize().getThreeDays() + tableSize)));
                    }
                    periodTimestamp = TimestampUtils.getEndOfDayTimestamp(TimestampUtils.subtractDays(timestamp, 7));
                    if (lifeCycle.getAccessed().getTimestamp() <= periodTimestamp) {
                        unusedDataAssets.withCount(unusedDataAssets.getCount().withSevenDays((Object)((Double)unusedDataAssets.getCount().getSevenDays() + 1.0)));
                        unusedDataAssets.withSize(unusedDataAssets.getSize().withSevenDays((Object)((Double)unusedDataAssets.getSize().getSevenDays() + tableSize)));
                    } else {
                        frequentlyUsedDataAssets.withCount(frequentlyUsedDataAssets.getCount().withSevenDays((Object)((Double)frequentlyUsedDataAssets.getCount().getSevenDays() + 1.0)));
                        frequentlyUsedDataAssets.withSize(frequentlyUsedDataAssets.getSize().withSevenDays((Object)((Double)frequentlyUsedDataAssets.getSize().getSevenDays() + tableSize)));
                    }
                    periodTimestamp = TimestampUtils.getEndOfDayTimestamp(TimestampUtils.subtractDays(timestamp, 14));
                    if (lifeCycle.getAccessed().getTimestamp() <= periodTimestamp) {
                        unusedDataAssets.withCount(unusedDataAssets.getCount().withFourteenDays((Object)((Double)unusedDataAssets.getCount().getFourteenDays() + 1.0)));
                        unusedDataAssets.withSize(unusedDataAssets.getSize().withFourteenDays((Object)((Double)unusedDataAssets.getSize().getFourteenDays() + tableSize)));
                    } else {
                        frequentlyUsedDataAssets.withCount(frequentlyUsedDataAssets.getCount().withFourteenDays((Object)((Double)frequentlyUsedDataAssets.getCount().getFourteenDays() + 1.0)));
                        frequentlyUsedDataAssets.withSize(frequentlyUsedDataAssets.getSize().withFourteenDays((Object)((Double)frequentlyUsedDataAssets.getSize().getFourteenDays() + tableSize)));
                    }
                    periodTimestamp = TimestampUtils.getEndOfDayTimestamp(TimestampUtils.subtractDays(timestamp, 30));
                    if (lifeCycle.getAccessed().getTimestamp() <= periodTimestamp) {
                        unusedDataAssets.withCount(unusedDataAssets.getCount().withThirtyDays((Object)((Double)unusedDataAssets.getCount().getThirtyDays() + 1.0)));
                        unusedDataAssets.withSize(unusedDataAssets.getSize().withThirtyDays((Object)((Double)unusedDataAssets.getSize().getThirtyDays() + tableSize)));
                    } else {
                        frequentlyUsedDataAssets.withCount(frequentlyUsedDataAssets.getCount().withThirtyDays((Object)((Double)frequentlyUsedDataAssets.getCount().getThirtyDays() + 1.0)));
                        frequentlyUsedDataAssets.withSize(frequentlyUsedDataAssets.getSize().withThirtyDays((Object)((Double)frequentlyUsedDataAssets.getSize().getThirtyDays() + tableSize)));
                    }
                    periodTimestamp = TimestampUtils.getEndOfDayTimestamp(TimestampUtils.subtractDays(timestamp, 60));
                    if (lifeCycle.getAccessed().getTimestamp() <= periodTimestamp) {
                        unusedDataAssets.withCount(unusedDataAssets.getCount().withSixtyDays((Object)((Double)unusedDataAssets.getCount().getSixtyDays() + 1.0)));
                        unusedDataAssets.withSize(unusedDataAssets.getSize().withSixtyDays((Object)((Double)unusedDataAssets.getSize().getSixtyDays() + tableSize)));
                    } else {
                        frequentlyUsedDataAssets.withCount(frequentlyUsedDataAssets.getCount().withSixtyDays((Object)((Double)frequentlyUsedDataAssets.getCount().getSixtyDays() + 1.0)));
                        frequentlyUsedDataAssets.withSize(frequentlyUsedDataAssets.getSize().withSixtyDays((Object)((Double)frequentlyUsedDataAssets.getSize().getSixtyDays() + tableSize)));
                    }
                }
                Double totalSize = aggregatedCostAnalysisData.totalSize() + tableSize;
                Double totalCount = aggregatedCostAnalysisData.totalCount() + 1.0;
                CostAnalysisWorkflow.AggregatedCostAnalysisData newAggregatedCostAnalysisData = new CostAnalysisWorkflow.AggregatedCostAnalysisData(totalSize, totalCount, unusedDataAssets, frequentlyUsedDataAssets);
                ((Map)((Map)aggregatedCostAnalysisDataMap.get(entityType)).get(serviceType)).put(serviceName, newAggregatedCostAnalysisData);
            }
            this.updateStats(input.size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.size())).withFailedCount(Integer.valueOf(input.size())).withSuccessCount(Integer.valueOf(0)).withMessage(String.format("Aggregated Cost Analysis Processor Encounter Failure: %s", e.getMessage())).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[AggregatedCostAnalysisProcessor] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.size());
            throw new SearchIndexException(error);
        }
        return aggregatedCostAnalysisReportDataList;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

