/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.costAnalysis.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.AccessDetails;
import org.openmetadata.schema.type.LifeCycle;
import org.openmetadata.schema.type.TableProfile;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.insights.workflows.costAnalysis.CostAnalysisWorkflow;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.TableRepository;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseServiceTablesProcessor
implements Processor<List<CostAnalysisWorkflow.CostAnalysisTableData>, ResultList<? extends EntityInterface>> {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseServiceTablesProcessor.class);
    private final StepStats stats = new StepStats();

    public DatabaseServiceTablesProcessor(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public List<CostAnalysisWorkflow.CostAnalysisTableData> process(ResultList<? extends EntityInterface> input, Map<String, Object> contextData) throws SearchIndexException {
        ArrayList<CostAnalysisWorkflow.CostAnalysisTableData> costAnalysisTableDataList = new ArrayList<CostAnalysisWorkflow.CostAnalysisTableData>();
        try {
            for (EntityInterface entityInterface : input.getData()) {
                Table tableProfileData;
                Optional<TableProfile> oTableProfile;
                Optional<AccessDetails> oAccessed;
                Table table = (Table)entityInterface;
                Optional<Object> oTableLifeCycle = Optional.empty();
                Optional<Double> oSize = Optional.empty();
                Optional<LifeCycle> oTableLifeCycleData = Optional.ofNullable(table.getLifeCycle());
                if (oTableLifeCycleData.isPresent() && (oAccessed = Optional.ofNullable(oTableLifeCycleData.get().getAccessed())).isPresent()) {
                    oTableLifeCycle = oTableLifeCycleData;
                }
                if ((oTableProfile = Optional.ofNullable((tableProfileData = ((TableRepository)Entity.getEntityRepository("table")).getLatestTableProfile(table.getFullyQualifiedName(), true)).getProfile())).isPresent()) {
                    oSize = Optional.ofNullable(oTableProfile.get().getSizeInByte());
                }
                if (!oTableLifeCycle.isPresent() && !oSize.isPresent()) continue;
                costAnalysisTableDataList.add(new CostAnalysisWorkflow.CostAnalysisTableData(table, oTableLifeCycle, oSize));
            }
            this.updateStats(input.getData().size(), 0);
        }
        catch (Exception e) {
            IndexingError indexingError = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.getData().size())).withFailedCount(Integer.valueOf(input.getData().size())).withSuccessCount(Integer.valueOf(0)).withMessage(String.format("Database Service Tables Processor Encounter Failure: %s", e.getMessage())).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[DatabaseServiceTAblesProcessor] Failed. Details: {}", (Object)JsonUtils.pojoToJson(indexingError));
            this.updateStats(0, input.getData().size());
            throw new SearchIndexException(indexingError);
        }
        return costAnalysisTableDataList;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

