/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.costAnalysis.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.analytics.RawCostAnalysisReportData;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.LifeCycle;
import org.openmetadata.service.apps.bundles.insights.workflows.costAnalysis.CostAnalysisWorkflow;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawCostAnalysisReportDataProcessor
implements Processor<List<RawCostAnalysisReportData>, List<CostAnalysisWorkflow.CostAnalysisTableData>> {
    private static final Logger LOG = LoggerFactory.getLogger(RawCostAnalysisReportDataProcessor.class);
    private final StepStats stats = new StepStats();

    public RawCostAnalysisReportDataProcessor(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public List<RawCostAnalysisReportData> process(List<CostAnalysisWorkflow.CostAnalysisTableData> input, Map<String, Object> contextData) throws SearchIndexException {
        ArrayList<RawCostAnalysisReportData> rawCostAnalysisReportDataList = new ArrayList<RawCostAnalysisReportData>();
        try {
            for (CostAnalysisWorkflow.CostAnalysisTableData tableData : input) {
                RawCostAnalysisReportData rawCostAnalysisReportData = new RawCostAnalysisReportData().withEntity(tableData.table().getEntityReference()).withLifeCycle((LifeCycle)tableData.oLifeCycle().orElse(null)).withSizeInByte((Double)tableData.oSize().orElse(null));
                rawCostAnalysisReportDataList.add(rawCostAnalysisReportData);
            }
            this.updateStats(input.size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.size())).withFailedCount(Integer.valueOf(input.size())).withSuccessCount(Integer.valueOf(0)).withMessage(String.format("Raw Cost Analysis Processor Encounter Failure: %s", e.getMessage())).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[RawCostAnalysisProcessor] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.size());
            throw new SearchIndexException(error);
        }
        return rawCostAnalysisReportDataList;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

