/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.dataAssets.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.ColumnsEntityInterface;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.insights.utils.TimestampUtils;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInsightsEntityEnricherProcessor
implements Processor<List<Map<String, Object>>, ResultList<? extends EntityInterface>> {
    private static final Logger LOG = LoggerFactory.getLogger(DataInsightsEntityEnricherProcessor.class);
    private final StepStats stats = new StepStats();
    private static final Set<String> NON_TIER_ENTITIES = Set.of("tag", "glossaryTerm", "dataProduct");

    public DataInsightsEntityEnricherProcessor(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public List<Map<String, Object>> process(ResultList<? extends EntityInterface> input, Map<String, Object> contextData) throws SearchIndexException {
        List<Map<String, Object>> enrichedMaps;
        try {
            enrichedMaps = input.getData().stream().map(entity -> this.getEntityVersions((EntityInterface)entity, contextData)).flatMap(Collection::stream).map(entityVersionMap -> this.enrichEntity((Map<String, Object>)entityVersionMap, contextData)).map(this::generateDailyEntitySnapshots).flatMap(Collection::stream).toList();
            this.updateStats(input.getData().size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.getData().size())).withFailedCount(Integer.valueOf(input.getData().size())).withSuccessCount(Integer.valueOf(0)).withMessage(String.format("Entities Enricher Encountered Failure: %s", e.getMessage())).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[DataInsightsEntityEnricherProcessor] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.getData().size());
            throw new SearchIndexException(error);
        }
        return enrichedMaps;
    }

    private List<Map<String, Object>> getEntityVersions(EntityInterface entity, Map<String, Object> contextData) {
        EntityRepository.EntityHistoryWithOffset entityHistoryWithOffset;
        List versions;
        String entityType = (String)contextData.get("entityType");
        Long endTimestamp = (Long)contextData.get("endTimestamp");
        Long startTimestamp = (Long)contextData.get("startTimestamp");
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        Long pointerTimestamp = endTimestamp;
        ArrayList<Map<String, Object>> entityVersions = new ArrayList<Map<String, Object>>();
        boolean historyDone = false;
        int nextOffset = 0;
        block0: while (!historyDone && !(versions = (entityHistoryWithOffset = entityRepository.listVersionsWithOffset(entity.getId(), 100, nextOffset)).entityHistory().getVersions()).isEmpty()) {
            nextOffset = entityHistoryWithOffset.nextOffset();
            for (Object version : versions) {
                HashMap<String, Long> versionMap;
                EntityInterface versionEntity = (EntityInterface)JsonUtils.readOrConvertValue(version, (Class)EntityInterface.ENTITY_TYPE_TO_CLASS_MAP.get(entityType.toLowerCase()));
                Long versionTimestamp = TimestampUtils.getStartOfDayTimestamp(versionEntity.getUpdatedAt());
                if (versionTimestamp > pointerTimestamp) continue;
                if (versionTimestamp < startTimestamp) {
                    versionMap = new HashMap<String, Long>();
                    versionMap.put("endTimestamp", pointerTimestamp);
                    versionMap.put("startTimestamp", startTimestamp);
                    versionMap.put("versionEntity", (Long)versionEntity);
                    entityVersions.add(versionMap);
                    historyDone = true;
                    continue block0;
                }
                versionMap = new HashMap();
                versionMap.put("endTimestamp", pointerTimestamp);
                versionMap.put("startTimestamp", TimestampUtils.getEndOfDayTimestamp(versionTimestamp));
                versionMap.put("versionEntity", (Long)versionEntity);
                entityVersions.add(versionMap);
                pointerTimestamp = TimestampUtils.getEndOfDayTimestamp(TimestampUtils.subtractDays(versionTimestamp, 1));
            }
        }
        return entityVersions;
    }

    private Map<String, Object> enrichEntity(Map<String, Object> entityVersionMap, Map<String, Object> contextData) {
        Optional<List> oEntityTags;
        EntityInterface entity = (EntityInterface)entityVersionMap.get("versionEntity");
        Long startTimestamp = (Long)entityVersionMap.get("startTimestamp");
        Long endTimestamp = (Long)entityVersionMap.get("endTimestamp");
        Map<String, Object> entityMap = JsonUtils.getMap(entity);
        String entityType = (String)contextData.get("entityType");
        List<Class<?>> interfaces = List.of(entity.getClass().getInterfaces());
        if (CommonUtil.nullOrEmpty((String)entityType)) {
            throw new IllegalArgumentException("[EsEntitiesProcessor] entityType cannot be null or empty.");
        }
        entityMap.put("entityType", entityType);
        entityMap.put("startTimestamp", startTimestamp);
        entityMap.put("endTimestamp", endTimestamp);
        Optional<List> oEntityOwners = Optional.ofNullable(entity.getOwners());
        if (oEntityOwners.isPresent() && !oEntityOwners.get().isEmpty()) {
            EntityReference entityOwner = (EntityReference)oEntityOwners.get().get(0);
            String ownerType = entityOwner.getType();
            if (ownerType.equals("team")) {
                entityMap.put("team", entityOwner.getName());
            } else {
                try {
                    User owner;
                    List teams;
                    Optional<User> oOwner = Optional.ofNullable((User)Entity.getEntityByName("user", entityOwner.getFullyQualifiedName(), "teams", Include.ALL));
                    if (oOwner.isPresent() && !(teams = (owner = oOwner.get()).getTeams()).isEmpty()) {
                        entityMap.put("team", ((EntityReference)teams.get(0)).getName());
                    }
                }
                catch (EntityNotFoundException ex) {
                    LOG.debug(String.format("Owner %s for %s '%s' version '%s' not found.", entityOwner.getFullyQualifiedName(), entityType, entity.getFullyQualifiedName(), entity.getVersion()));
                }
            }
        }
        if ((oEntityTags = Optional.ofNullable(entity.getTags())).isPresent()) {
            Optional<String> oEntityTier = this.getEntityTier(oEntityTags.get().stream().map(TagLabel::getTagFQN).toList());
            oEntityTier.ifPresentOrElse(s -> entityMap.put("tier", s), () -> {
                if (!NON_TIER_ENTITIES.contains(entityType)) {
                    entityMap.put("tier", "NoTier");
                }
            });
        } else if (!NON_TIER_ENTITIES.contains(entityType)) {
            entityMap.put("tier", "NoTier");
        }
        if (interfaces.contains(ColumnsEntityInterface.class)) {
            entityMap.put("numberOfColumns", ((ColumnsEntityInterface)entity).getColumns().size());
            entityMap.put("numberOfColumnsWithDescription", ((ColumnsEntityInterface)entity).getColumns().stream().map(column -> CommonUtil.nullOrEmpty((String)column.getDescription()) ? 0 : 1).reduce(0, Integer::sum));
            entityMap.put("hasDescription", CommonUtil.nullOrEmpty((String)entity.getDescription()) ? 0 : 1);
        }
        Optional<Object> oCustomProperties = Optional.ofNullable(entityMap.remove("extension"));
        oCustomProperties.ifPresent(o -> entityMap.put(String.format("%sCustomProperty", entityType), o));
        entityMap.remove("changeDescription");
        entityMap.remove("sampleData");
        return entityMap;
    }

    private Optional<String> getEntityTier(List<String> entityTags) {
        Optional<String> entityTier = Optional.empty();
        List<String> tierTags = entityTags.stream().filter(tag -> tag.startsWith("Tier")).toList();
        if (!tierTags.isEmpty()) {
            entityTier = Optional.of(tierTags.get(0));
        }
        return entityTier;
    }

    private List<Map<String, Object>> generateDailyEntitySnapshots(Map<String, Object> entityVersionMap) {
        Long startTimestamp = (Long)entityVersionMap.remove("startTimestamp");
        Long endTimestamp = (Long)entityVersionMap.remove("endTimestamp");
        ArrayList<Map<String, Object>> dailyEntitySnapshots = new ArrayList<Map<String, Object>>();
        Long pointerTimestamp = endTimestamp;
        while (pointerTimestamp >= startTimestamp) {
            HashMap<String, Object> dailyEntitySnapshot = new HashMap<String, Object>(entityVersionMap);
            dailyEntitySnapshot.put("@timestamp", TimestampUtils.getStartOfDayTimestamp(pointerTimestamp));
            dailyEntitySnapshots.add(dailyEntitySnapshot);
            pointerTimestamp = TimestampUtils.subtractDays(pointerTimestamp, 1);
        }
        return dailyEntitySnapshots;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

