/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.dataAssets.processors;

import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import os.org.opensearch.action.bulk.BulkRequest;
import os.org.opensearch.action.index.IndexRequest;
import os.org.opensearch.common.xcontent.XContentType;

public class DataInsightsOpenSearchProcessor
implements Processor<BulkRequest, List<Map<String, Object>>> {
    private static final Logger LOG = LoggerFactory.getLogger(DataInsightsOpenSearchProcessor.class);
    private final StepStats stats = new StepStats();

    public DataInsightsOpenSearchProcessor(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public BulkRequest process(List<Map<String, Object>> input, Map<String, Object> contextData) throws SearchIndexException {
        BulkRequest requests;
        String index = (String)contextData.get("DataStreamKey");
        LOG.debug("[OsEntitiesProcessor] Processing a Batch of Size: {}, Index: {} ", (Object)input.size(), (Object)index);
        try {
            requests = DataInsightsOpenSearchProcessor.buildBulkRequests(index, input);
            LOG.debug("[OsEntitiesProcessor] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{input.size(), input.size(), 0});
            this.updateStats(input.size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.size())).withFailedCount(Integer.valueOf(input.size())).withSuccessCount(Integer.valueOf(0)).withMessage("Data Insights OpenSearch Processor Encountered Failure. Converting requests to ES Request.").withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[DataInsightsOpenSearchProcessor] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.size());
            throw new SearchIndexException(error);
        }
        return requests;
    }

    private static BulkRequest buildBulkRequests(String index, List<Map<String, Object>> input) {
        BulkRequest bulkRequests = new BulkRequest();
        for (Map<String, Object> entity : input) {
            IndexRequest request = DataInsightsOpenSearchProcessor.getIndexRequest(index, entity);
            bulkRequests.add(request);
        }
        return bulkRequests;
    }

    private static IndexRequest getIndexRequest(String index, Map<String, Object> entity) {
        IndexRequest indexRequest = new IndexRequest(index);
        indexRequest.source(JsonUtils.pojoToJson(entity), XContentType.JSON);
        indexRequest.opType("create");
        return indexRequest;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

