/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.webAnalytics.processors;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.analytics.WebAnalyticEntityViewReportData;
import org.openmetadata.schema.analytics.WebAnalyticEventData;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAnalyticsEntityViewProcessor
implements Processor<Map<String, WebAnalyticEntityViewReportData>, ResultList<WebAnalyticEventData>> {
    private static final Logger LOG = LoggerFactory.getLogger(WebAnalyticsEntityViewProcessor.class);
    private final StepStats stats = new StepStats();
    private final List<String> entities = List.of("chart", "dashboard", "database", "databaseSchema", "mlmodel", "pipeline", "table", "topic");

    public WebAnalyticsEntityViewProcessor(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public Map<String, WebAnalyticEntityViewReportData> process(ResultList<WebAnalyticEventData> input, Map<String, Object> contextData) throws SearchIndexException {
        try {
            for (WebAnalyticEventData event : input.getData()) {
                this.processEvent(event, contextData);
            }
            this.updateStats(input.getData().size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.getData().size())).withFailedCount(Integer.valueOf(input.getData().size())).withSuccessCount(Integer.valueOf(0)).withMessage(String.format("WebAnalytics Entity View Processor Encounter Failure: %s", e.getMessage())).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[WebAnalyticsEntityViewProcessor] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.getData().size());
            throw new SearchIndexException(error);
        }
        return (HashMap)contextData.get("entityViewReportData");
    }

    private void processEvent(WebAnalyticEventData event, Map<String, Object> contextData) {
        HashMap entityViewData = (HashMap)contextData.get("entityViewReportData");
        Map<String, Object> eventData = JsonUtils.getMap(event.getEventData());
        Optional<ProcessedUrl> oProcessedUrl = this.processUrl((String)eventData.get("url"));
        if (oProcessedUrl.isPresent()) {
            String entityType = oProcessedUrl.get().entityType();
            String entityFqn = oProcessedUrl.get().entityFqn();
            String fullUrl = (String)eventData.get("fullUrl");
            if (!entityViewData.containsKey(entityFqn)) {
                try {
                    EntityInterface entity = (EntityInterface)Entity.getEntityByName(URLDecoder.decode(entityType, StandardCharsets.UTF_8), entityFqn, "*", Include.NON_DELETED, true);
                    WebAnalyticEntityViewReportData webAnalyticEntityViewReportData = new WebAnalyticEntityViewReportData().withEntityType(entityType).withEntityFqn(entityFqn);
                    Optional<List> oEntityOwners = Optional.ofNullable(entity.getOwners());
                    if (oEntityOwners.isPresent() && !oEntityOwners.get().isEmpty()) {
                        EntityReference entityOwner = (EntityReference)oEntityOwners.get().get(0);
                        if (entityOwner.getId().equals(UUID.fromString((String)eventData.get("userId")))) {
                            return;
                        }
                        webAnalyticEntityViewReportData.setOwnerId(entityOwner.getId().toString());
                        webAnalyticEntityViewReportData.setOwner(entityOwner.getName());
                    }
                    List<String> entityTags = entity.getTags().stream().map(TagLabel::getTagFQN).toList();
                    webAnalyticEntityViewReportData.setTagsFQN(entityTags);
                    Optional<String> entityTier = this.getEntityTier(entityTags);
                    entityTier.ifPresent(arg_0 -> ((WebAnalyticEntityViewReportData)webAnalyticEntityViewReportData).setEntityTier(arg_0));
                    Optional<String> oEntityHref = this.findEntityHref(entityType, entityFqn, fullUrl);
                    oEntityHref.ifPresent(arg_0 -> ((WebAnalyticEntityViewReportData)webAnalyticEntityViewReportData).setEntityHref(arg_0));
                    webAnalyticEntityViewReportData.setViews(Integer.valueOf(1));
                    entityViewData.put(entityFqn, webAnalyticEntityViewReportData);
                }
                catch (EntityNotFoundException rx) {
                    LOG.debug("Entity {} Not Found", (Object)entityFqn);
                }
            } else {
                WebAnalyticEntityViewReportData webAnalyticEntityViewReportData = (WebAnalyticEntityViewReportData)entityViewData.get(entityFqn);
                if (Optional.ofNullable(webAnalyticEntityViewReportData.getEntityHref()).isEmpty()) {
                    Optional<String> oEntityHref = this.findEntityHref(entityType, entityFqn, fullUrl);
                    oEntityHref.ifPresent(arg_0 -> ((WebAnalyticEntityViewReportData)webAnalyticEntityViewReportData).setEntityHref(arg_0));
                }
                webAnalyticEntityViewReportData.setViews(Integer.valueOf(webAnalyticEntityViewReportData.getViews() + 1));
                entityViewData.put(entityFqn, webAnalyticEntityViewReportData);
            }
        }
    }

    private Optional<ProcessedUrl> processUrl(String url) {
        Optional<ProcessedUrl> processedUrl = Optional.empty();
        List<String> splitUrl = List.of(url.split("/"));
        if (!splitUrl.isEmpty() && this.entities.contains(splitUrl.get(1))) {
            processedUrl = Optional.of(new ProcessedUrl(splitUrl.get(1), splitUrl.get(2)));
        }
        return processedUrl;
    }

    private Optional<String> findEntityHref(String entityType, String entityFqn, String fullUrl) {
        Optional<String> entityHref = Optional.empty();
        Pattern hRefPattern = Pattern.compile(String.format("(.*%s/%s)", Pattern.quote(entityType), Pattern.quote(entityFqn)), 2);
        Matcher matcher = hRefPattern.matcher(fullUrl);
        if (matcher.find()) {
            entityHref = Optional.of(matcher.group(0));
        }
        return entityHref;
    }

    private Optional<String> getEntityTier(List<String> entityTags) {
        Optional<String> entityTier = Optional.empty();
        List<String> tierTags = entityTags.stream().filter(tag -> tag.startsWith("Tier")).toList();
        if (!tierTags.isEmpty()) {
            entityTier = Optional.of(tierTags.get(0));
        }
        return entityTier;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    private record ProcessedUrl(String entityType, String entityFqn) {
    }
}

