/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.webAnalytics.processors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.analytics.WebAnalyticUserActivityReportData;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.apps.bundles.insights.workflows.webAnalytics.WebAnalyticsWorkflow;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAnalyticsUserActivityAggregator
implements Processor<Map<UUID, WebAnalyticUserActivityReportData>, Map<UUID, WebAnalyticsWorkflow.UserActivityData>> {
    private static final Logger LOG = LoggerFactory.getLogger(WebAnalyticsUserActivityAggregator.class);
    private final String name = "[WebAnalyticsWorkflow] User Activity Aggregator";
    private final StepStats stats = new StepStats();

    public WebAnalyticsUserActivityAggregator(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public Map<UUID, WebAnalyticUserActivityReportData> process(Map<UUID, WebAnalyticsWorkflow.UserActivityData> input, Map<String, Object> contextData) throws SearchIndexException {
        try {
            for (WebAnalyticsWorkflow.UserActivityData userActivitydata : input.values()) {
                this.processEvent(userActivitydata, contextData);
            }
            this.updateStats(input.size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.size())).withFailedCount(Integer.valueOf(input.size())).withSuccessCount(Integer.valueOf(0)).withMessage(String.format("Web Analytics User Activity Aggregator Encounter Failure: %s", e.getMessage())).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[WebAnalyticsUserActivityAggregator] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.size());
            throw new SearchIndexException(error);
        }
        return (HashMap)contextData.get("userActivityReportData");
    }

    private void processEvent(WebAnalyticsWorkflow.UserActivityData userActivityData, Map<String, Object> contextData) {
        HashMap userActivityReportData = (HashMap)contextData.get("userActivityReportData");
        int totalSessionDurationSeconds = 0;
        for (List<Long> timestampList : userActivityData.sessions().values()) {
            totalSessionDurationSeconds = (int)((long)totalSessionDurationSeconds + (Collections.max(timestampList) - Collections.min(timestampList)) / 1000L);
        }
        WebAnalyticUserActivityReportData data = new WebAnalyticUserActivityReportData().withUserId(userActivityData.userId()).withUserName(userActivityData.userName()).withTeam(userActivityData.team()).withTotalSessions(Integer.valueOf(userActivityData.totalSessions())).withTotalSessionDuration(Integer.valueOf(totalSessionDurationSeconds)).withTotalPageView(Integer.valueOf(userActivityData.totalPageView())).withLastSession(userActivityData.lastSession());
        userActivityReportData.put(userActivityData.userId(), data);
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    public String getName() {
        return this.name;
    }
}

