/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.webAnalytics.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.analytics.WebAnalyticEventData;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.insights.workflows.webAnalytics.WebAnalyticsWorkflow;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAnalyticsUserActivityProcessor
implements Processor<Map<UUID, WebAnalyticsWorkflow.UserActivityData>, ResultList<WebAnalyticEventData>> {
    private static final Logger LOG = LoggerFactory.getLogger(WebAnalyticsUserActivityProcessor.class);
    private final StepStats stats = new StepStats();

    public WebAnalyticsUserActivityProcessor(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public Map<UUID, WebAnalyticsWorkflow.UserActivityData> process(ResultList<WebAnalyticEventData> input, Map<String, Object> contextData) throws SearchIndexException {
        try {
            for (WebAnalyticEventData event : input.getData()) {
                this.processEvent(event, contextData);
            }
            this.updateStats(input.getData().size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.getData().size())).withFailedCount(Integer.valueOf(input.getData().size())).withSuccessCount(Integer.valueOf(0)).withMessage(String.format("WebAnalytics User Activity Processor Encounter Failure: %s", e.getMessage())).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[WebAnalyticsUserActivityProcessor] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.getData().size());
            throw new SearchIndexException(error);
        }
        return (HashMap)contextData.get("userActivityData");
    }

    private void processEvent(WebAnalyticEventData event, Map<String, Object> contextData) {
        HashMap userActivityDataMap = (HashMap)contextData.get("userActivityData");
        Map<String, Object> eventData = JsonUtils.getMap(event.getEventData());
        UUID userId = UUID.fromString((String)eventData.get("userId"));
        UUID sessionId = UUID.fromString((String)eventData.get("sessionId"));
        Long timestamp = event.getTimestamp();
        if (!userActivityDataMap.containsKey(userId)) {
            try {
                User userDetails = (User)Entity.getEntityRepository("user").get(null, userId, new EntityUtil.Fields(Set.of("teams")), Include.ALL, false);
                HashMap<UUID, List<Long>> sessions = new HashMap<UUID, List<Long>>();
                sessions.put(sessionId, List.of(timestamp));
                String team = null;
                if (!userDetails.getTeams().isEmpty()) {
                    team = ((EntityReference)userDetails.getTeams().get(0)).getName();
                }
                WebAnalyticsWorkflow.UserActivityData userActivityData = new WebAnalyticsWorkflow.UserActivityData(userDetails.getName(), userId, team, sessions, 1, 1, timestamp);
                userActivityDataMap.put(userId, userActivityData);
            }
            catch (EntityNotFoundException ex) {
                LOG.debug(String.format("Skipping user with id '%s' because it was not found in the database.", userId));
            }
        } else {
            WebAnalyticsWorkflow.UserActivityData userActivityData = (WebAnalyticsWorkflow.UserActivityData)userActivityDataMap.get(userId);
            Map<UUID, List<Long>> sessions = userActivityData.sessions();
            int totalSessions = userActivityData.totalSessions();
            int totalPageView = userActivityData.totalPageView() + 1;
            Long lastSession = userActivityData.lastSession();
            if (sessions.containsKey(sessionId)) {
                ArrayList<Long> sessionList = new ArrayList<Long>((Collection)sessions.get(sessionId));
                sessionList.add(timestamp);
                sessions.put(sessionId, sessionList);
            } else {
                sessions.put(sessionId, List.of(timestamp));
                ++totalSessions;
            }
            if (timestamp > lastSession) {
                lastSession = timestamp;
            }
            WebAnalyticsWorkflow.UserActivityData newUserActivityData = new WebAnalyticsWorkflow.UserActivityData(userActivityData.userName(), userId, userActivityData.team(), sessions, totalPageView, totalSessions, lastSession);
            userActivityDataMap.put(userId, newUserActivityData);
        }
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

