/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights.workflows.webAnalytics.sources;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.analytics.WebAnalyticEventData;
import org.openmetadata.schema.analytics.type.WebAnalyticEventType;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.insights.utils.TimestampUtils;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.WebAnalyticEventRepository;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Source;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedWebAnalyticEventDataSource
implements Source<ResultList<WebAnalyticEventData>> {
    private static final Logger LOG = LoggerFactory.getLogger(PaginatedWebAnalyticEventDataSource.class);
    private final String name;
    private final int batchSize;
    private final Long startTs;
    private final Long endTs;
    private final int totalRecords;
    private final String entityType = "webAnalyticEvent";
    private final WebAnalyticEventRepository repository = (WebAnalyticEventRepository)Entity.getEntityRepository("webAnalyticEvent");
    private final String eventType = WebAnalyticEventType.PAGE_VIEW.toString();
    private final List<String> readerErrors = new ArrayList<String>();
    private final StepStats stats = new StepStats();
    private String lastFailedCursor = null;
    private String cursor = RestUtil.encodeCursor("0");
    private boolean isDone = false;

    public PaginatedWebAnalyticEventDataSource(int batchSize, Long startTs, Long endTs) {
        this.batchSize = batchSize;
        this.startTs = startTs;
        this.endTs = endTs;
        this.name = String.format("[WebAnalyticsWorkflow] Event Data Source %s", TimestampUtils.timestampToString(startTs, "YYYY-MM-dd"));
        this.totalRecords = this.repository.listWebAnalyticEventDataCount(this.eventType, startTs, endTs, false);
        this.stats.withTotalRecords(Integer.valueOf(this.totalRecords)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public ResultList<WebAnalyticEventData> readNext(Map<String, Object> contextData) throws SearchIndexException {
        ResultList<WebAnalyticEventData> data = null;
        if (!this.isDone) {
            data = this.read(this.cursor);
            this.cursor = data.getPaging().getAfter();
            if (this.cursor == null) {
                this.isDone = true;
            }
        }
        return data;
    }

    private ResultList<WebAnalyticEventData> read(String cursor) throws SearchIndexException {
        ResultList<WebAnalyticEventData> result;
        LOG.debug("[PaginatedEntityTimeSeriesSource] Fetching a Batch of Size: {} ", (Object)this.batchSize);
        try {
            result = this.repository.listWebAnalyticEventDataWithOffset(cursor, this.eventType, this.batchSize, this.startTs, this.endTs, false, true);
            if (!result.getErrors().isEmpty()) {
                this.lastFailedCursor = this.cursor;
                if (result.getPaging().getAfter() == null) {
                    this.isDone = true;
                } else {
                    this.cursor = result.getPaging().getAfter();
                }
                return result;
            }
            LOG.debug("[PaginatedEntitiesSource] Batch Stats :- %n Submitted : {} Success: {} Failed: {}", new Object[]{this.batchSize, result.getData().size(), result.getErrors().size()});
        }
        catch (Exception e) {
            int submittedRecords;
            this.lastFailedCursor = this.cursor;
            int remainingRecords = this.stats.getTotalRecords() - this.stats.getFailedRecords() - this.stats.getSuccessRecords();
            if (remainingRecords - this.batchSize <= 0) {
                submittedRecords = remainingRecords;
                this.updateStats(0, remainingRecords);
                this.cursor = null;
                this.isDone = true;
            } else {
                submittedRecords = this.batchSize;
                String decodedCursor = RestUtil.decodeCursor(cursor);
                this.cursor = RestUtil.encodeCursor(String.valueOf(Integer.parseInt(decodedCursor) + this.batchSize));
                this.updateStats(0, this.batchSize);
            }
            IndexingError indexingError = new IndexingError().withErrorSource(IndexingError.ErrorSource.READER).withSubmittedCount(Integer.valueOf(submittedRecords)).withSuccessCount(Integer.valueOf(0)).withFailedCount(Integer.valueOf(submittedRecords)).withMessage("Issues in Reading A Batch For Entities. No Relationship Issue , Json Processing or DB issue.").withLastFailedCursor(this.lastFailedCursor).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug(indexingError.getMessage());
            throw new SearchIndexException(indexingError);
        }
        return result;
    }

    @Override
    public void reset() {
        this.cursor = null;
        this.isDone = false;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public Long getStartTs() {
        return this.startTs;
    }

    public Long getEndTs() {
        return this.endTs;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    @Override
    public String getEntityType() {
        return this.entityType;
    }

    public WebAnalyticEventRepository getRepository() {
        return this.repository;
    }

    public String getEventType() {
        return this.eventType;
    }

    @Override
    public List<String> getReaderErrors() {
        return this.readerErrors;
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    @Override
    public String getLastFailedCursor() {
        return this.lastFailedCursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }
}

