/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.clients.pipeline;

import io.prometheus.client.Counter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppMarketPlaceDefinition;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineServiceClientResponse;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.sdk.PipelineServiceClientInterface;
import org.openmetadata.sdk.exception.PipelineServiceClientException;
import org.openmetadata.service.util.MicrometerBundleSingleton;

public class MeteredPipelineServiceClient
implements PipelineServiceClientInterface {
    private final String DEPLOY = "deploy";
    private final String RUN = "run";
    private final String DELETE = "delete";
    private final String TOGGLE = "toggle";
    private final String KILL = "kill";
    private final String GET_LOGS = "get_logs";
    private final String GET_STATUS = "get_status";
    private final String RUN_AUTOMATIONS_WORKFLOW = "run_automations_workflow";
    private final String RUN_APPLICATION_FLOW = "run_application_flow";
    private final String VALIDATE_APP_REGISTRATION = "validate_app_registration";
    private final PipelineServiceClientInterface decoratedClient;
    private final Counter pipelineClientStatusCounter = MicrometerBundleSingleton.pipelineClientStatusCounter;

    public MeteredPipelineServiceClient(PipelineServiceClientInterface decoratedClient) {
        this.decoratedClient = decoratedClient;
    }

    private <T> T executeWithMetering(String name, Supplier<T> operation) {
        try {
            T result = operation.get();
            ((Counter.Child)this.pipelineClientStatusCounter.labels(new String[]{name, "200"})).inc();
            return result;
        }
        catch (PipelineServiceClientException e) {
            ((Counter.Child)this.pipelineClientStatusCounter.labels(new String[]{name, Integer.toString(e.getResponse().getStatus())})).inc();
            throw e;
        }
        catch (Exception e) {
            ((Counter.Child)this.pipelineClientStatusCounter.labels(new String[]{name, "unknown"})).inc();
            throw e;
        }
    }

    private PipelineServiceClientResponse respondWithMetering(String name, Supplier<PipelineServiceClientResponse> operation) {
        try {
            PipelineServiceClientResponse result = operation.get();
            ((Counter.Child)this.pipelineClientStatusCounter.labels(new String[]{name, Integer.toString(result.getCode())})).inc();
            return result;
        }
        catch (PipelineServiceClientException e) {
            ((Counter.Child)this.pipelineClientStatusCounter.labels(new String[]{name, Integer.toString(e.getResponse().getStatus())})).inc();
            throw e;
        }
        catch (Exception e) {
            ((Counter.Child)this.pipelineClientStatusCounter.labels(new String[]{name, "unknown"})).inc();
            throw e;
        }
    }

    public PipelineServiceClientResponse deployPipeline(IngestionPipeline ingestionPipeline, ServiceEntityInterface service) {
        return this.respondWithMetering("deploy", () -> this.decoratedClient.deployPipeline(ingestionPipeline, service));
    }

    public PipelineServiceClientResponse runPipeline(IngestionPipeline ingestionPipeline, ServiceEntityInterface service) {
        return this.respondWithMetering("run", () -> this.decoratedClient.runPipeline(ingestionPipeline, service));
    }

    public PipelineServiceClientResponse deletePipeline(IngestionPipeline ingestionPipeline) {
        return this.respondWithMetering("delete", () -> this.decoratedClient.deletePipeline(ingestionPipeline));
    }

    public List<PipelineStatus> getQueuedPipelineStatusInternal(IngestionPipeline ingestionPipeline) {
        return this.decoratedClient.getQueuedPipelineStatusInternal(ingestionPipeline);
    }

    public PipelineServiceClientResponse toggleIngestion(IngestionPipeline ingestionPipeline) {
        return this.respondWithMetering("toggle", () -> this.decoratedClient.toggleIngestion(ingestionPipeline));
    }

    public Map<String, String> getLastIngestionLogs(IngestionPipeline ingestionPipeline, String after) {
        return this.executeWithMetering("get_logs", () -> this.decoratedClient.getLastIngestionLogs(ingestionPipeline, after));
    }

    public PipelineServiceClientResponse killIngestion(IngestionPipeline ingestionPipeline) {
        return this.respondWithMetering("kill", () -> this.decoratedClient.killIngestion(ingestionPipeline));
    }

    public String getPlatform() {
        return this.decoratedClient.getPlatform();
    }

    public URL validateServiceURL(String serviceURL) {
        return this.decoratedClient.validateServiceURL(serviceURL);
    }

    public String getBasicAuthenticationHeader(String username, String password) {
        return this.decoratedClient.getBasicAuthenticationHeader(username, password);
    }

    public Boolean validServerClientVersions(String clientVersion) {
        return this.decoratedClient.validServerClientVersions(clientVersion);
    }

    public Response getHostIp() {
        return this.decoratedClient.getHostIp();
    }

    public String getServiceStatusBackoff() {
        return this.executeWithMetering("get_status", () -> ((PipelineServiceClientInterface)this.decoratedClient).getServiceStatusBackoff());
    }

    public PipelineServiceClientResponse getServiceStatus() {
        return this.respondWithMetering("get_status", () -> ((PipelineServiceClientInterface)this.decoratedClient).getServiceStatus());
    }

    public List<PipelineStatus> getQueuedPipelineStatus(IngestionPipeline ingestionPipeline) {
        return this.decoratedClient.getQueuedPipelineStatus(ingestionPipeline);
    }

    public PipelineServiceClientResponse runAutomationsWorkflow(Workflow workflow) {
        return this.respondWithMetering("run_automations_workflow", () -> this.decoratedClient.runAutomationsWorkflow(workflow));
    }

    public PipelineServiceClientResponse runApplicationFlow(App application) {
        return this.respondWithMetering("run_application_flow", () -> this.decoratedClient.runApplicationFlow(application));
    }

    public PipelineServiceClientResponse validateAppRegistration(AppMarketPlaceDefinition app) {
        return this.respondWithMetering("validate_app_registration", () -> this.decoratedClient.validateAppRegistration(app));
    }
}

