/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.clients.pipeline;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.configuration.pipelineServiceClient.PipelineServiceClientConfiguration;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineServiceClientResponse;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.sdk.PipelineServiceClientInterface;
import org.openmetadata.sdk.exception.PipelineServiceClientException;
import org.openmetadata.sdk.exception.PipelineServiceVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipelineServiceClient
implements PipelineServiceClientInterface {
    private static final Logger LOG;
    protected final boolean pipelineServiceClientEnabled;
    protected final String hostIp;
    protected final boolean ingestionIpInfoEnabled;
    private String platform;
    protected static final String AUTH_HEADER = "Authorization";
    protected static final String CONTENT_HEADER = "Content-Type";
    protected static final String CONTENT_TYPE = "application/json";
    private static final Integer MAX_ATTEMPTS;
    private static final Integer BACKOFF_TIME_SECONDS;
    private static final String DISABLED_STATUS = "disabled";
    protected static final String SERVER_VERSION;

    public PipelineServiceClient(PipelineServiceClientConfiguration pipelineServiceClientConfiguration) {
        this.pipelineServiceClientEnabled = pipelineServiceClientConfiguration.getEnabled();
        this.hostIp = pipelineServiceClientConfiguration.getHostIp();
        this.ingestionIpInfoEnabled = pipelineServiceClientConfiguration.getIngestionIpInfoEnabled();
    }

    public final URL validateServiceURL(String serviceURL) {
        try {
            return new URL(serviceURL);
        }
        catch (MalformedURLException e) {
            throw new PipelineServiceClientException(serviceURL + " Malformed.");
        }
    }

    public final String getBasicAuthenticationHeader(String username, String password) {
        String valueToEncode = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    public static String getServerVersion() throws IOException {
        InputStream fileInput = PipelineServiceClient.class.getResourceAsStream("/catalog/VERSION");
        Properties props = new Properties();
        if (fileInput != null) {
            props.load(fileInput);
        }
        return props.getProperty("version", "unknown");
    }

    public final String getVersionFromString(String version) {
        if (version != null) {
            return Pattern.compile("(\\d+.\\d+.\\d+)").matcher(version).results().map(m -> m.group(1)).findFirst().orElseThrow(() -> new PipelineServiceVersionException(String.format("Cannot extract version x.y.z from %s", version)));
        }
        throw new PipelineServiceVersionException("Received version as null");
    }

    public final Boolean validServerClientVersions(String clientVersion) {
        return this.getVersionFromString(clientVersion).equals(this.getVersionFromString(SERVER_VERSION));
    }

    public String buildVersionMismatchErrorMessage(String ingestionVersion, String serverVersion) {
        if (this.getVersionFromString(ingestionVersion).compareTo(this.getVersionFromString(serverVersion)) < 0) {
            return String.format("Ingestion version [%s] is older than Server Version [%s]. Please upgrade your ingestion client.", ingestionVersion, serverVersion);
        }
        return String.format("Server version [%s] is older than Ingestion Version [%s]. Please upgrade your server or downgrade the ingestion client.", serverVersion, ingestionVersion);
    }

    protected PipelineServiceClientResponse buildHealthyStatus(String ingestionVersion) {
        return new PipelineServiceClientResponse().withCode(Integer.valueOf(200)).withVersion(ingestionVersion).withPlatform(this.getPlatform());
    }

    protected PipelineServiceClientResponse buildUnhealthyStatus(String reason) {
        return new PipelineServiceClientResponse().withCode(Integer.valueOf(500)).withReason(reason).withPlatform(this.getPlatform());
    }

    public final Response getHostIp() {
        if (this.ingestionIpInfoEnabled) {
            return this.getHostIpInternal();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private Response getHostIpInternal() {
        try {
            Map<String, String> body = CommonUtil.nullOrEmpty((String)this.hostIp) ? this.requestGetHostIp() : Map.of("ip", this.hostIp);
            return Response.ok(body, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            LOG.error("Failed to get Pipeline Service host IP. {}", (Object)e.getMessage());
            Map<String, String> body = Map.of("ip", "Failed to find the IP of Airflow Container. Please make sure https://api.ipify.org, https://api.my-ip.io/ip reachable from your network or that the `hostIp` setting is configured.");
            return Response.ok(body, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    public String getServiceStatusBackoff() {
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(MAX_ATTEMPTS.intValue()).waitDuration(Duration.ofMillis((long)BACKOFF_TIME_SECONDS.intValue() * 1000L)).retryOnResult(response -> !"healthy".equals(response)).failAfterMaxAttempts(false).build();
        Retry retry = Retry.of((String)"getServiceStatus", (RetryConfig)retryConfig);
        Supplier<String> responseSupplier = () -> {
            try {
                PipelineServiceClientResponse status = this.getServiceStatus();
                return status.getCode() != 200 ? "unhealthy" : "healthy";
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return (String)retry.executeSupplier(responseSupplier);
    }

    public PipelineServiceClientResponse getServiceStatus() {
        if (this.pipelineServiceClientEnabled) {
            return this.getServiceStatusInternal();
        }
        return this.buildHealthyStatus(DISABLED_STATUS).withPlatform(DISABLED_STATUS);
    }

    public List<PipelineStatus> getQueuedPipelineStatus(IngestionPipeline ingestionPipeline) {
        if (this.pipelineServiceClientEnabled) {
            return this.getQueuedPipelineStatusInternal(ingestionPipeline);
        }
        return new ArrayList<PipelineStatus>();
    }

    protected abstract PipelineServiceClientResponse getServiceStatusInternal();

    protected abstract Map<String, String> requestGetHostIp();

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    static {
        String rawServerVersion;
        LOG = LoggerFactory.getLogger(PipelineServiceClient.class);
        MAX_ATTEMPTS = 3;
        BACKOFF_TIME_SECONDS = 5;
        try {
            rawServerVersion = PipelineServiceClient.getServerVersion();
        }
        catch (IOException e) {
            rawServerVersion = "unknown";
        }
        SERVER_VERSION = rawServerVersion;
    }
}

