/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.clients.pipeline;

import java.lang.reflect.InvocationTargetException;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.configuration.pipelineServiceClient.PipelineServiceClientConfiguration;
import org.openmetadata.sdk.PipelineServiceClientInterface;
import org.openmetadata.sdk.exception.PipelineServiceClientException;
import org.openmetadata.service.clients.pipeline.MeteredPipelineServiceClient;
import org.openmetadata.service.clients.pipeline.PipelineServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineServiceClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineServiceClientFactory.class);
    private static PipelineServiceClientInterface pipelineServiceClient;

    private PipelineServiceClientFactory() {
    }

    public static PipelineServiceClientInterface createPipelineServiceClient(PipelineServiceClientConfiguration config) {
        if (pipelineServiceClient != null || CommonUtil.nullOrEmpty((Object)config)) {
            return pipelineServiceClient;
        }
        String pipelineServiceClientClass = config.getClassName();
        LOG.debug("Registering PipelineServiceClient: {}", (Object)pipelineServiceClientClass);
        try {
            PipelineServiceClientInterface client = Class.forName(pipelineServiceClientClass).asSubclass(PipelineServiceClient.class).getConstructor(PipelineServiceClientConfiguration.class).newInstance(config);
            pipelineServiceClient = new MeteredPipelineServiceClient(client);
            return pipelineServiceClient;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PipelineServiceClientException(String.format("Error trying to load PipelineServiceClient %s: %s", pipelineServiceClientClass, e));
        }
    }

    public static PipelineServiceClientInterface getPipelineServiceClient() {
        return pipelineServiceClient;
    }
}

