/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openmetadata.schema.dataInsight.type.AggregatedUsedVsUnusedAssetsSize;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class AggregatedUsedvsUnusedAssetsSizeAggregator<A, H, B, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    protected AggregatedUsedvsUnusedAssetsSizeAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        H histogramBucket = this.getHistogramBucket(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B bucket : this.getBuckets(histogramBucket)) {
            Long timestamp = this.getKeyAsEpochTimestamp(bucket);
            S totalUnused = this.getAggregations(bucket, "totalUnused");
            S totalUsed = this.getAggregations(bucket, "totalUsed");
            Double used = Objects.requireNonNullElse(this.getValue(totalUsed), 0.0);
            Double unused = Objects.requireNonNullElse(this.getValue(totalUnused), 0.0);
            Double total = used + unused;
            double usedPercentage = 0.0;
            double unusedPercentage = 0.0;
            if (total != 0.0) {
                usedPercentage = used / total;
                unusedPercentage = unused / total;
            }
            data.add(new AggregatedUsedVsUnusedAssetsSize().withTimestamp(timestamp).withUnused(unused).withUnusedPercentage(Double.valueOf(unusedPercentage)).withUsed(used).withUsedPercentage(Double.valueOf(usedPercentage)));
        }
        return data;
    }

    protected abstract H getHistogramBucket(A var1);

    protected abstract List<? extends B> getBuckets(H var1);

    protected abstract long getKeyAsEpochTimestamp(B var1);

    protected abstract S getAggregations(B var1, String var2);

    protected abstract Double getValue(S var1);
}

